/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.HashMap;
import org.uma.jmetal.problem.IntegerDoubleProblem;
import org.uma.jmetal.solution.IntegerDoubleSolution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;

public class DefaultIntegerDoubleSolution
extends AbstractGenericSolution<Number, IntegerDoubleProblem<?>>
implements IntegerDoubleSolution {
    private int numberOfIntegerVariables;
    private int numberOfDoubleVariables;

    public DefaultIntegerDoubleSolution(IntegerDoubleProblem<?> problem) {
        super(problem);
        this.numberOfIntegerVariables = problem.getNumberOfIntegerVariables();
        this.numberOfDoubleVariables = problem.getNumberOfDoubleVariables();
        this.initializeIntegerDoubleVariables();
        this.initializeObjectiveValues();
    }

    public DefaultIntegerDoubleSolution(DefaultIntegerDoubleSolution solution) {
        super(solution.problem);
        int i;
        for (i = 0; i < ((IntegerDoubleProblem)this.problem).getNumberOfObjectives(); ++i) {
            this.setObjective(i, solution.getObjective(i));
        }
        for (i = 0; i < this.numberOfIntegerVariables; ++i) {
            this.setVariableValue(i, solution.getVariableValue(i));
        }
        for (i = this.numberOfIntegerVariables; i < this.numberOfIntegerVariables + this.numberOfDoubleVariables; ++i) {
            this.setVariableValue(i, solution.getVariableValue(i));
        }
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Number getUpperBound(int index) {
        return ((IntegerDoubleProblem)this.problem).getUpperBound(index);
    }

    @Override
    public int getNumberOfIntegerVariables() {
        return this.numberOfIntegerVariables;
    }

    @Override
    public int getNumberOfDoubleVariables() {
        return this.numberOfDoubleVariables;
    }

    @Override
    public Number getLowerBound(int index) {
        return ((IntegerDoubleProblem)this.problem).getLowerBound(index);
    }

    public DefaultIntegerDoubleSolution copy() {
        return new DefaultIntegerDoubleSolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        return ((Number)this.getVariableValue(index)).toString();
    }

    private void initializeIntegerDoubleVariables() {
        Number value;
        int i;
        for (i = 0; i < this.numberOfIntegerVariables; ++i) {
            value = this.randomGenerator.nextInt((Integer)this.getLowerBound(i), (Integer)this.getUpperBound(i));
            this.setVariableValue(i, value);
        }
        for (i = this.numberOfIntegerVariables; i < this.getNumberOfVariables(); ++i) {
            value = this.randomGenerator.nextDouble((Double)this.getLowerBound(i), (Double)this.getUpperBound(i));
            this.setVariableValue(i, value);
        }
    }
}

