/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.uma.jmetal.solution.SolutionEvaluator;

public class ObjectiveFactory {
    public <Solution> Collection<SolutionEvaluator.Objective<Solution, ?>> createFromGetters(Class<Solution> solutionClass) {
        LinkedList objectives = new LinkedList();
        for (Method method : solutionClass.getMethods()) {
            if (method.getParameterTypes().length != 0 || method.getReturnType() == null || method.getName().equals("getClass") || !method.getName().matches("get[^a-z].*")) continue;
            String name = method.getName().substring(3);
            objectives.add(this.createObjectiveOn(solutionClass, method, name, method.getReturnType()));
        }
        return objectives;
    }

    public <Solution> Collection<SolutionEvaluator.Objective<Solution, ?>> createFromGettersWithoutSetters(Class<Solution> solutionClass) {
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method method : solutionClass.getMethods()) {
            String name;
            if (this.isGetter(method)) {
                name = method.getName().substring(3);
                getters.put(name, method);
                continue;
            }
            if (!this.isSetter(method)) continue;
            name = method.getName().substring(3);
            setters.put(name, method);
        }
        getters.keySet().removeAll(setters.keySet());
        LinkedList objectives = new LinkedList();
        for (Map.Entry entry : getters.entrySet()) {
            String name = (String)entry.getKey();
            Method getter = (Method)entry.getValue();
            objectives.add(this.createObjectiveOn(solutionClass, getter, name, getter.getReturnType()));
        }
        return objectives;
    }

    private boolean isSetter(Method method) {
        return method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE && method.getName().matches("set[^a-z].*");
    }

    private boolean isGetter(Method method) {
        return method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE && !method.getName().equals("getClass") && method.getName().matches("get[^a-z].*");
    }

    private <Solution, Value> SolutionEvaluator.Objective<Solution, Value> createObjectiveOn(final Class<Solution> solutionClass, final Method getter, final String name, final Class<Value> type) {
        return new SolutionEvaluator.Objective<Solution, Value>(){

            @Override
            public Value get(Solution solution) {
                try {
                    return getter.invoke(solution, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getDescription() {
                return type.getSimpleName() + " value for the " + solutionClass.getSimpleName() + " solutions.";
            }
        };
    }
}

