/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.ErrorRatio;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontNormalizer;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.point.util.PointSolution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public abstract class AbstractAlgorithmRunner {
    public static void printFinalSolutionSet(List<? extends Solution<?>> population) {
        new SolutionListOutput(population).setSeparator("\t").setVarFileOutputContext(new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext(new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }

    public static <S extends Solution<?>> void printQualityIndicators(List<S> population, String paretoFrontFile) throws FileNotFoundException {
        ArrayFront referenceFront = new ArrayFront(paretoFrontFile);
        FrontNormalizer frontNormalizer = new FrontNormalizer(referenceFront);
        Front normalizedReferenceFront = frontNormalizer.normalize(referenceFront);
        Front normalizedFront = frontNormalizer.normalize(new ArrayFront(population));
        List<PointSolution> normalizedPopulation = FrontUtils.convertFrontToSolutionList(normalizedFront);
        String outputString = "\n";
        outputString = outputString + "Hypervolume (N) : " + new PISAHypervolume<PointSolution>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "Hypervolume     : " + new PISAHypervolume<S>(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "Epsilon (N)     : " + new Epsilon<PointSolution>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "Epsilon         : " + new Epsilon<S>(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "GD (N)          : " + new GenerationalDistance<PointSolution>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "GD              : " + new GenerationalDistance<S>(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "IGD (N)         : " + new InvertedGenerationalDistance<PointSolution>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "IGD             : " + new InvertedGenerationalDistance<S>(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "IGD+ (N)        : " + new InvertedGenerationalDistancePlus<PointSolution>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "IGD+            : " + new InvertedGenerationalDistancePlus<S>(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "Spread (N)      : " + new Spread<PointSolution>(normalizedReferenceFront).evaluate(normalizedPopulation) + "\n";
        outputString = outputString + "Spread          : " + new Spread<S>(referenceFront).evaluate(population) + "\n";
        outputString = outputString + "Error ratio     : " + new ErrorRatio<List<S>>(referenceFront).evaluate(population) + "\n";
        JMetalLogger.logger.info(outputString);
    }
}

