/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.util.JMetalException;

public class AlgorithmRunner {
    private long computingTime;

    private AlgorithmRunner(Executor execute) {
        this.computingTime = execute.computingTime;
    }

    public long getComputingTime() {
        return this.computingTime;
    }

    public static class Executor {
        Algorithm<?> algorithm;
        long computingTime;

        public Executor(Algorithm<?> algorithm) {
            this.algorithm = algorithm;
        }

        public AlgorithmRunner execute() {
            long initTime = System.currentTimeMillis();
            Thread thread = new Thread(this.algorithm);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new JMetalException("Error in thread.join()", e);
            }
            this.computingTime = System.currentTimeMillis() - initTime;
            return new AlgorithmRunner(this);
        }
    }
}

