/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.lang.reflect.InvocationTargetException;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.JMetalException;

public class ProblemUtils {
    public static <S> Problem<S> loadProblem(String problemName) {
        Problem problem;
        try {
            problem = (Problem)Class.forName(problemName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new JMetalException("newInstance() cannot instantiate (abstract class)", e);
        }
        catch (IllegalAccessException e) {
            throw new JMetalException("newInstance() is not usable (uses restriction)", e);
        }
        catch (InvocationTargetException e) {
            throw new JMetalException("an exception was thrown during the call of newInstance()", e);
        }
        catch (NoSuchMethodException e) {
            throw new JMetalException("getConstructor() was not able to find the constructor without arguments", e);
        }
        catch (ClassNotFoundException e) {
            throw new JMetalException("Class.forName() did not recognized the name of the class", e);
        }
        return problem;
    }
}

