/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.artificialdecisionmaker.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.uma.jmetal.algorithm.InteractiveAlgorithm;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.problem.impl.AbstractIntegerDoubleProblem;
import org.uma.jmetal.problem.impl.AbstractIntegerProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.artificialdecisionmaker.ArtificialDecisionMaker;
import org.uma.jmetal.util.artificialdecisionmaker.DecisionTreeEstimator;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.distance.impl.EuclideanDistanceBetweenSolutionsInObjectiveSpace;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class ArtificialDecisionMakerDecisionTree<S extends Solution<?>>
extends ArtificialDecisionMaker<S, List<S>> {
    protected List<Double> idealOjectiveVector = null;
    protected List<Double> nadirObjectiveVector = null;
    protected List<Double> rankingCoeficient = null;
    protected List<Double> asp = null;
    protected double tolerance;
    protected JMetalRandom random = null;
    protected double considerationProbability;
    protected int numberOfObjectives;
    protected double varyingProbability;
    protected int evaluations;
    protected int maxEvaluations;
    protected List<Double> allReferencePoints;
    protected List<Double> currentReferencePoint;
    protected List<Double> distances;
    private S solutionRun = null;

    public ArtificialDecisionMakerDecisionTree(Problem<S> problem, InteractiveAlgorithm<S, List<S>> algorithm, double considerationProbability, double tolerance, int maxEvaluations, List<Double> rankingCoeficient, List<Double> asp) {
        super(problem, algorithm);
        this.considerationProbability = considerationProbability;
        this.tolerance = tolerance;
        this.numberOfObjectives = problem.getNumberOfObjectives();
        this.random = JMetalRandom.getInstance();
        this.maxEvaluations = maxEvaluations;
        this.rankingCoeficient = rankingCoeficient;
        if (rankingCoeficient == null || rankingCoeficient.isEmpty()) {
            this.initialiceRankingCoeficient();
        }
        this.allReferencePoints = new ArrayList<Double>();
        this.distances = new ArrayList<Double>();
        if (asp != null) {
            this.asp = new ArrayList<Double>();
            for (Double obj : asp) {
                this.asp.add(obj);
            }
        }
    }

    private void initialiceRankingCoeficient() {
        this.rankingCoeficient = new ArrayList<Double>();
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            this.rankingCoeficient.add(1.0 / (double)this.problem.getNumberOfObjectives());
        }
    }

    private void updateObjectiveVector(List<S> solutionList) {
        for (int j = 0; j < this.numberOfObjectives; ++j) {
            Collections.sort(solutionList, new ObjectiveComparator(j));
            double objetiveMinn = ((Solution)solutionList.get(0)).getObjective(j);
            double objetiveMaxn = ((Solution)solutionList.get(solutionList.size() - 1)).getObjective(j);
            this.idealOjectiveVector.add(objetiveMinn);
            this.nadirObjectiveVector.add(objetiveMaxn);
        }
        if (this.problem instanceof AbstractDoubleProblem) {
            AbstractDoubleProblem aux = (AbstractDoubleProblem)this.problem;
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                this.idealOjectiveVector.add(aux.getLowerBound(i));
                this.nadirObjectiveVector.add(aux.getUpperBound(i));
            }
        } else if (this.problem instanceof AbstractIntegerProblem) {
            AbstractIntegerProblem aux = (AbstractIntegerProblem)this.problem;
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                this.idealOjectiveVector.add(new Double(aux.getLowerBound(i).intValue()));
                this.nadirObjectiveVector.add(new Double(aux.getUpperBound(i).intValue()));
            }
        } else if (this.problem instanceof AbstractIntegerDoubleProblem) {
            AbstractIntegerDoubleProblem aux = (AbstractIntegerDoubleProblem)this.problem;
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                this.idealOjectiveVector.add(aux.getLowerBound(i).doubleValue());
                this.nadirObjectiveVector.add(aux.getUpperBound(i).doubleValue());
            }
        }
        if (this.asp == null) {
            this.asp = this.idealOjectiveVector;
        }
    }

    @Override
    protected List<Double> generatePreferenceInformation() {
        this.idealOjectiveVector = new ArrayList<Double>(this.numberOfObjectives);
        this.nadirObjectiveVector = new ArrayList<Double>(this.numberOfObjectives);
        ArrayList<Solution> solutions = new ArrayList<Solution>();
        Solution sol = (Solution)this.problem.createSolution();
        this.problem.evaluate(sol);
        solutions.add(sol);
        this.updateObjectiveVector(solutions);
        ArrayList<Double> referencePoint = new ArrayList<Double>(this.numberOfObjectives);
        for (int j = 0; j < this.numberOfObjectives; ++j) {
            double rand = this.random.nextDouble(0.0, 1.0);
            if (rand < this.considerationProbability * this.rankingCoeficient.get(j)) {
                referencePoint.add(this.asp.get(j));
                continue;
            }
            referencePoint.add(this.nadirObjectiveVector.get(j));
        }
        this.currentReferencePoint = referencePoint;
        this.allReferencePoints.addAll(referencePoint);
        return referencePoint;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        boolean stop;
        boolean bl = stop = this.evaluations > this.maxEvaluations;
        if (this.indexOfRelevantObjectiveFunctions != null) {
            stop = stop || this.indexOfRelevantObjectiveFunctions.size() == this.numberOfObjectives;
        }
        return stop;
    }

    @Override
    protected void initProgress() {
        this.evaluations = 0;
        this.varyingProbability = this.considerationProbability;
    }

    @Override
    protected void updateProgress() {
        ++this.evaluations;
    }

    @Override
    protected List<Integer> relevantObjectiveFunctions(List<S> front) {
        ArrayList order = new ArrayList();
        ArrayList<Integer> indexRelevantObjectivesFunctions = new ArrayList<Integer>();
        TreeMap map = new TreeMap(Collections.reverseOrder());
        for (int i = 0; i < this.rankingCoeficient.size(); ++i) {
            List aux = map.getOrDefault(this.rankingCoeficient.get(i), new ArrayList());
            aux.add(i);
            map.putIfAbsent(this.rankingCoeficient.get(i), aux);
        }
        Set keys = map.keySet();
        for (Double key : keys) {
            order.addAll((Collection)map.get(key));
        }
        S solution = this.getSolution(front, this.currentReferencePoint);
        for (Integer i : order) {
            double rand = this.random.nextDouble(0.0, 1.0);
            if (this.asp.get(i) - solution.getObjective(i) < this.tolerance && rand < this.considerationProbability) {
                indexRelevantObjectivesFunctions.add(i);
            } else if (rand < this.varyingProbability) {
                indexRelevantObjectivesFunctions.add(i);
            }
            this.varyingProbability -= this.varyingProbability / (double)i.intValue() * (double)indexRelevantObjectivesFunctions.size();
        }
        return indexRelevantObjectivesFunctions;
    }

    @Override
    protected List<Double> calculateReferencePoints(List<Integer> indexOfRelevantObjectiveFunctions, List<S> front, List<S> paretoOptimalSolutions) {
        ArrayList<Double> result = new ArrayList<Double>();
        ArrayList<S> temporal = new ArrayList<S>(front);
        S solution = this.getSolution(temporal, this.currentReferencePoint);
        this.solutionRun = solution;
        temporal.remove(solution);
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            if (indexOfRelevantObjectiveFunctions.contains(i)) {
                result.add(this.asp.get(i) - (this.asp.get(i) - solution.getObjective(i)) / 2.0);
                continue;
            }
            result.add(this.prediction(i, front, solution));
        }
        this.calculateDistance(this.solutionRun, this.asp);
        this.currentReferencePoint = result;
        this.allReferencePoints.addAll(result);
        return result;
    }

    private void calculateDistance(S solution, List<Double> referencePoint) {
        EuclideanDistanceBetweenSolutionsInObjectiveSpace<DoubleSolution> euclidean = new EuclideanDistanceBetweenSolutionsInObjectiveSpace<DoubleSolution>();
        double distance = euclidean.getDistance((DoubleSolution)solution, this.getSolutionFromRP(referencePoint));
        this.distances.add(distance);
    }

    private DoubleSolution getSolutionFromRP(List<Double> referencePoint) {
        DoubleSolution result = (DoubleSolution)this.problem.createSolution();
        for (int i = 0; i < result.getNumberOfObjectives(); ++i) {
            result.setObjective(i, referencePoint.get(i));
            result.setVariableValue(i, referencePoint.get(i));
        }
        return result;
    }

    private double prediction(int index, List<S> paretoOptimalSolutions, S solution) {
        DecisionTreeEstimator<S> dte = new DecisionTreeEstimator<S>(paretoOptimalSolutions);
        double data = dte.doPrediction(index, solution);
        return data;
    }

    @Override
    protected void updateParetoOptimal(List<S> front, List<S> paretoOptimalSolutions) {
        paretoOptimalSolutions = new ArrayList<S>(front);
    }

    @Override
    public List<Double> getReferencePoints() {
        return this.allReferencePoints;
    }

    @Override
    public List<Double> getDistances() {
        return this.distances;
    }

    private S getSolution(List<S> front, List<Double> referencePoint) {
        Solution result = (Solution)front.get(0);
        EuclideanDistanceBetweenSolutionsInObjectiveSpace<DoubleSolution> euclidean = new EuclideanDistanceBetweenSolutionsInObjectiveSpace<DoubleSolution>();
        TreeMap<Double, Solution> map = new TreeMap<Double, Solution>();
        DoubleSolution aux = this.getSolutionFromRP(referencePoint);
        for (Solution solution : front) {
            double distance = euclidean.getDistance((DoubleSolution)solution, aux);
            map.put(distance, solution);
        }
        result = (Solution)map.get(map.firstKey());
        return (S)result;
    }
}

