/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.fileinput.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.uma.jmetal.util.JMetalException;

public class ReadDoubleDataFile {
    public double[] readFile(String fileName) throws FileNotFoundException {
        InputStream inputStream = this.getClass().getResourceAsStream("/" + fileName);
        if (inputStream == null) {
            inputStream = new FileInputStream(fileName);
        }
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(isr);
        ArrayList<Double> list = new ArrayList<Double>();
        try {
            String line = br.readLine();
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                while (tokenizer.hasMoreTokens()) {
                    double value = new Double(tokenizer.nextToken());
                    list.add(value);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            throw new JMetalException("Error reading file", e);
        }
        catch (NumberFormatException e) {
            throw new JMetalException("Format number exception when reading file", e);
        }
        double[] result = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (Double)list.get(i);
        }
        return result;
    }
}

