/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.point.Point;

public class ArrayPoint
implements Point {
    protected double[] point;

    public ArrayPoint() {
        this.point = null;
    }

    public ArrayPoint(int dimensions) {
        this.point = new double[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            this.point[i] = 0.0;
        }
    }

    public ArrayPoint(Point point) {
        if (point == null) {
            throw new JMetalException("The point is null");
        }
        this.point = new double[point.getNumberOfDimensions()];
        for (int i = 0; i < point.getNumberOfDimensions(); ++i) {
            this.point[i] = point.getDimensionValue(i);
        }
    }

    public ArrayPoint(Solution<?> solution) {
        if (solution == null) {
            throw new JMetalException("The solution is null");
        }
        int dimensions = solution.getNumberOfObjectives();
        this.point = new double[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            this.point[i] = solution.getObjective(i);
        }
    }

    public ArrayPoint(double[] point) {
        if (point == null) {
            throw new JMetalException("The array of values is null");
        }
        this.point = new double[point.length];
        System.arraycopy(point, 0, this.point, 0, point.length);
    }

    public ArrayPoint(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        InputStreamReader isr = new InputStreamReader(fis);
        BufferedReader br = new BufferedReader(isr);
        ArrayList<Double> auxiliarPoint = new ArrayList<Double>();
        String aux = br.readLine();
        while (aux != null) {
            StringTokenizer st = new StringTokenizer(aux);
            while (st.hasMoreTokens()) {
                Double value = new Double(st.nextToken());
                auxiliarPoint.add(value);
            }
            aux = br.readLine();
        }
        this.point = new double[auxiliarPoint.size()];
        for (int i = 0; i < auxiliarPoint.size(); ++i) {
            this.point[i] = (Double)auxiliarPoint.get(i);
        }
        br.close();
    }

    @Override
    public int getNumberOfDimensions() {
        return this.point.length;
    }

    @Override
    public double[] getValues() {
        return this.point;
    }

    @Override
    public double getDimensionValue(int index) {
        if (index < 0 || index >= this.point.length) {
            throw new JMetalException("Index value invalid: " + index + ". The point length is: " + this.point.length);
        }
        return this.point[index];
    }

    @Override
    public void setDimensionValue(int index, double value) {
        if (index < 0 || index >= this.point.length) {
            throw new JMetalException("Index value invalid: " + index + ". The point length is: " + this.point.length);
        }
        this.point[index] = value;
    }

    public String toString() {
        String result = "";
        for (double anObjectives_ : this.point) {
            result = result + anObjectives_ + " ";
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayPoint that = (ArrayPoint)o;
        return Arrays.equals(this.point, that.point);
    }

    public int hashCode() {
        return Arrays.hashCode(this.point);
    }
}

