/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.point.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.point.Point;

public class PointSolution
implements Solution<Double> {
    private int numberOfObjectives;
    private double[] objectives;
    protected Map<Object, Object> attributes;

    public PointSolution(int numberOfObjectives) {
        this.numberOfObjectives = numberOfObjectives;
        this.objectives = new double[numberOfObjectives];
        this.attributes = new HashMap<Object, Object>();
    }

    public PointSolution(Point point) {
        this.numberOfObjectives = point.getNumberOfDimensions();
        this.objectives = new double[this.numberOfObjectives];
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            this.objectives[i] = point.getDimensionValue(i);
        }
    }

    public PointSolution(Solution<?> solution) {
        this.numberOfObjectives = solution.getNumberOfObjectives();
        this.objectives = new double[this.numberOfObjectives];
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            this.objectives[i] = solution.getObjective(i);
        }
    }

    public PointSolution(PointSolution point) {
        this(point.getNumberOfObjectives());
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            this.objectives[i] = point.getObjective(i);
        }
    }

    @Override
    public void setObjective(int index, double value) {
        this.objectives[index] = value;
    }

    @Override
    public double getObjective(int index) {
        return this.objectives[index];
    }

    @Override
    public Double getVariableValue(int index) {
        return null;
    }

    @Override
    public void setVariableValue(int index, Double value) {
    }

    @Override
    public String getVariableValueString(int index) {
        return null;
    }

    @Override
    public int getNumberOfVariables() {
        return 0;
    }

    @Override
    public int getNumberOfObjectives() {
        return this.numberOfObjectives;
    }

    public PointSolution copy() {
        return new PointSolution(this);
    }

    @Override
    public void setAttribute(Object id, Object value) {
        this.attributes.put(id, value);
    }

    @Override
    public Object getAttribute(Object id) {
        return this.attributes.get(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointSolution that = (PointSolution)o;
        if (this.numberOfObjectives != that.numberOfObjectives) {
            return false;
        }
        return Arrays.equals(this.objectives, that.objectives);
    }

    public int hashCode() {
        return Arrays.hashCode(this.objectives);
    }

    public String toString() {
        return Arrays.toString(this.objectives);
    }
}

