/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.utility;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.impl.DefaultDoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class GenerateReferenceFrontFromFile {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            throw new JMetalException("Wrong number of arguments: two file names are required.");
        }
        String inputFileName = args[0];
        String outputFileName = args[1];
        NonDominatedSolutionListArchive<DoubleSolution> archive = null;
        if (Files.isRegularFile(Paths.get(inputFileName, new String[0]), new LinkOption[0])) {
            archive = GenerateReferenceFrontFromFile.readDataFromFile(inputFileName);
        } else if (Files.isDirectory(Paths.get(inputFileName, new String[0]), new LinkOption[0])) {
            List fileNameList = Files.list(Paths.get(inputFileName, new String[0])).map(s -> s.toString()).collect(Collectors.toList());
            archive = new NonDominatedSolutionListArchive();
            for (String fileName : fileNameList) {
                System.out.println(fileName);
                archive.join(GenerateReferenceFrontFromFile.readDataFromFile(fileName));
            }
        } else {
            throw new JMetalException("Error opening file/directory");
        }
        new SolutionListOutput(archive.getSolutionList()).setSeparator("\t").setFunFileOutputContext(new DefaultFileOutputContext(outputFileName)).print();
    }

    private static NonDominatedSolutionListArchive<DoubleSolution> readDataFromFile(String inputFileName) {
        Stream<String> lines;
        try {
            lines = Files.lines(Paths.get(inputFileName, new String[0]), Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new JMetalException(e);
        }
        List numbers = lines.map(line -> {
            String[] textNumbers = line.split(" ");
            ArrayList<Double> listOfNumbers = new ArrayList<Double>();
            for (String number : textNumbers) {
                listOfNumbers.add(Double.parseDouble(number));
            }
            return listOfNumbers;
        }).collect(Collectors.toList());
        int numberOfObjectives = ((List)numbers.get(0)).size();
        DummyProblem dummyProblem = new DummyProblem(numberOfObjectives);
        NonDominatedSolutionListArchive<DoubleSolution> archive = new NonDominatedSolutionListArchive<DoubleSolution>();
        numbers.stream().forEach(list -> {
            DefaultDoubleSolution solution = new DefaultDoubleSolution(dummyProblem);
            for (int i = 0; i < numberOfObjectives; ++i) {
                solution.setObjective(i, (Double)list.get(i));
            }
            archive.add(solution);
        });
        return archive;
    }

    private static class DummyProblem
    extends AbstractDoubleProblem {
        public DummyProblem(int numberOfObjectives) {
            this.setNumberOfObjectives(numberOfObjectives);
        }

        @Override
        public void evaluate(DoubleSolution solution) {
        }
    }
}

