/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import weka.clusterers.AbstractClusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.core.Instance;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class AbstractDensityBasedClusterer
extends AbstractClusterer
implements DensityBasedClusterer {
    private static final long serialVersionUID = -5950728041704213845L;

    @Override
    public abstract double[] clusterPriors() throws Exception;

    @Override
    public abstract double[] logDensityPerClusterForInstance(Instance var1) throws Exception;

    @Override
    public double logDensityForInstance(Instance instance) throws Exception {
        double[] a2 = this.logJointDensitiesForInstance(instance);
        double max = a2[Utils.maxIndex(a2)];
        double sum = 0.0;
        for (int i = 0; i < a2.length; ++i) {
            sum += Math.exp(a2[i] - max);
        }
        return max + Math.log(sum);
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        return Utils.logs2probs(this.logJointDensitiesForInstance(instance));
    }

    @Override
    public double[] logJointDensitiesForInstance(Instance inst) throws Exception {
        double[] weights = this.logDensityPerClusterForInstance(inst);
        double[] priors = this.clusterPriors();
        for (int i = 0; i < weights.length; ++i) {
            if (!(priors[i] > 0.0)) {
                throw new IllegalArgumentException("Cluster empty!");
            }
            int n = i;
            weights[n] = weights[n] + Math.log(priors[i]);
        }
        return weights;
    }

    public static DensityBasedClusterer[] makeCopies(DensityBasedClusterer model, int num) throws Exception {
        if (model == null) {
            throw new Exception("No model clusterer set");
        }
        DensityBasedClusterer[] clusterers = new DensityBasedClusterer[num];
        SerializedObject so = new SerializedObject(model);
        for (int i = 0; i < clusterers.length; ++i) {
            clusterers[i] = (DensityBasedClusterer)so.getObject();
        }
        return clusterers;
    }
}

