/*
 * Decompiled with CFR 0.152.
 */
package weka.core.packageManagement;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import weka.core.Defaults;
import weka.core.Environment;
import weka.core.Settings;
import weka.core.packageManagement.DefaultPackage;
import weka.core.packageManagement.Dependency;
import weka.core.packageManagement.Package;
import weka.core.packageManagement.PackageConstraint;
import weka.core.packageManagement.PackageManager;

public class DefaultPackageManager
extends PackageManager {
    protected static final int BUFF_SIZE = 100000;
    protected static final byte[] m_buffer = new byte[100000];
    protected static final String INSTALLED_PACKAGE_CACHE_FILE = "installedPackageCache.ser";
    protected static List<Package> s_installedPackageList;
    protected int m_timeout = 5000;
    protected static final String TIMEOUT_PROPERTY = "weka.packageManager.timeout";

    public DefaultPackageManager() {
        String timeout = System.getProperty(TIMEOUT_PROPERTY);
        if (timeout != null && timeout.length() > 0) {
            try {
                this.m_timeout = Integer.parseInt(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Defaults getDefaultSettings() {
        return new DefaultPMDefaults();
    }

    @Override
    public void applySettings(Settings settings) {
        this.m_timeout = settings.getSetting(settings.getID(), DefaultPMDefaults.SOCKET_TIMEOUT_KEY, Integer.valueOf(5000), Environment.getSystemWide());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected File downloadArchive(URL packageURL, String fileExtension, PrintStream ... progress) throws Exception {
        String packageArchiveName = packageURL.toString();
        packageArchiveName = packageArchiveName.substring(0, packageArchiveName.lastIndexOf("." + fileExtension) + 3);
        packageArchiveName = packageArchiveName.substring(0, packageArchiveName.lastIndexOf(46));
        packageArchiveName = packageArchiveName.substring(packageArchiveName.lastIndexOf(47), packageArchiveName.length());
        File tmpDownload = File.createTempFile(packageArchiveName, "." + fileExtension);
        for (PrintStream progres : progress) {
            progres.println("[DefaultPackageManager] Tmp file: " + tmpDownload.toString());
        }
        URLConnection conn = this.getConnection(packageURL);
        BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
        BufferedOutputStream bo = new BufferedOutputStream(new FileOutputStream(tmpDownload));
        int totalBytesRead = 0;
        while (true) {
            byte[] byArray = m_buffer;
            // MONITORENTER : m_buffer
            int amountRead = bi.read(m_buffer);
            if (amountRead == -1) {
                PrintStream[] arr$ = progress;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) {
                        // MONITOREXIT : byArray
                        bi.close();
                        bo.close();
                        return tmpDownload;
                    }
                    PrintStream progres = arr$[i$];
                    progres.print("[DefaultPackageManager] downloaded " + totalBytesRead / 1000 + " KB\r");
                    ++i$;
                }
            }
            bo.write(m_buffer, 0, amountRead);
            totalBytesRead += amountRead;
            for (PrintStream progres : progress) {
                progres.print("%%[DefaultPackageManager] downloaded " + totalBytesRead / 1000 + " KB\r");
            }
            // MONITOREXIT : byArray
        }
    }

    @Override
    public Package getURLPackageInfo(URL packageURL) throws Exception {
        File downloaded = this.downloadArchive(packageURL, "zip", new PrintStream[0]);
        return this.getPackageArchiveInfo(downloaded);
    }

    @Override
    public Package getRepositoryPackageInfo(String packageName) throws Exception {
        return this.getRepositoryPackageInfo(packageName, "Latest");
    }

    @Override
    public List<Object> getRepositoryPackageVersions(String packageName) throws Exception {
        String versionNumber;
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String versionsS = this.m_packageRepository.toString() + "/" + packageName + "/" + "versions.txt";
        URL packageURL = new URL(versionsS);
        URLConnection conn = this.getConnection(packageURL);
        BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        ArrayList<Object> versions = new ArrayList<Object>();
        while ((versionNumber = bi.readLine()) != null) {
            versions.add(versionNumber.trim());
        }
        bi.close();
        return versions;
    }

    @Override
    public Package getRepositoryPackageInfo(String packageName, Object version2) throws Exception {
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        if (version2 == null) {
            version2 = "Latest";
        }
        String packageS = this.m_packageRepository.toString() + "/" + packageName + "/" + version2.toString() + ".props";
        URL packageURL = new URL(packageS);
        URLConnection conn = this.getConnection(packageURL);
        BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
        Properties packageProperties = new Properties();
        packageProperties.load(bi);
        bi.close();
        return new DefaultPackage(this.m_packageHome, this, packageProperties);
    }

    private Package getPackageArchiveInfo(File packageArchive) throws Exception {
        return this.getPackageArchiveInfo(packageArchive.getAbsolutePath());
    }

    @Override
    public Package getPackageArchiveInfo(String packageArchivePath) throws Exception {
        ZipFile zip = new ZipFile(new File(packageArchivePath));
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (!entry.getName().endsWith("Description.props")) continue;
            InputStream is = zip.getInputStream(entry);
            Properties packageProperties = new Properties();
            packageProperties.load(new BufferedInputStream(is));
            is.close();
            DefaultPackage pkg = new DefaultPackage(this.m_packageHome, this, packageProperties);
            return pkg;
        }
        throw new Exception("Unable to find Description file in package archive!");
    }

    @Override
    public Package getInstalledPackageInfo(String packageName) throws Exception {
        File packageDescription = new File(this.m_packageHome.getAbsoluteFile() + File.separator + packageName + File.separator + "Description.props");
        if (!packageDescription.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(packageDescription);
        Properties packageProperties = new Properties();
        packageProperties.load(fis);
        fis.close();
        DefaultPackage pkg = new DefaultPackage(this.m_packageHome, this, packageProperties);
        return pkg;
    }

    protected boolean establishPackageHome() {
        if (this.m_packageHome == null) {
            return false;
        }
        if (!this.m_packageHome.exists() && !this.m_packageHome.mkdir()) {
            System.err.println("Unable to create packages directory (" + this.m_packageHome.getAbsolutePath() + ")");
            return false;
        }
        return true;
    }

    public static void deleteDir(File dir, PrintStream ... progress) throws Exception {
        File[] contents = dir.listFiles();
        if (contents.length != 0) {
            for (File f : contents) {
                if (f.isDirectory()) {
                    DefaultPackageManager.deleteDir(f, new PrintStream[0]);
                    continue;
                }
                for (PrintStream progres : progress) {
                    progres.println("[DefaultPackageManager] removing: " + f.toString());
                }
                if (f.delete()) continue;
                System.err.println("[DefaultPackageManager] can't delete file " + f.toString());
                f.deleteOnExit();
            }
        }
        if (!dir.delete()) {
            System.err.println("[DefaultPackageManager] can't delete directory " + dir.toString());
            dir.deleteOnExit();
        }
        for (PrintStream progres : progress) {
            progres.println("[DefaultPackageManager] removing: " + dir.toString());
        }
    }

    @Override
    public void uninstallPackage(String packageName, PrintStream ... progress) throws Exception {
        File packageToDel = new File(this.m_packageHome.toString() + File.separator + packageName);
        if (!packageToDel.exists()) {
            throw new Exception("[DefaultPackageManager] Can't remove " + packageName + " because it doesn't seem to be installed!");
        }
        DefaultPackageManager.deleteDir(packageToDel, progress);
        s_installedPackageList = null;
        this.deleteInstalledPackageCacheFile();
    }

    @Override
    public String installPackageFromArchive(String packageArchivePath, PrintStream ... progress) throws Exception {
        Properties packageProps = (Properties)this.getPackageArchiveInfo(packageArchivePath).getPackageMetaData();
        String packageName = packageProps.getProperty("PackageName");
        String additionalLibs = packageProps.getProperty("AdditionalLibs");
        String[] additionalLibURLs = null;
        if (additionalLibs != null && additionalLibs.length() > 0) {
            additionalLibURLs = additionalLibs.split(",");
        }
        if (packageName == null) {
            throw new Exception("Unable to find the name of the package in the Description file for " + packageArchivePath);
        }
        this.installPackage(packageArchivePath, packageName, progress);
        if (additionalLibURLs != null) {
            this.installAdditionalLibs(packageName, additionalLibURLs, progress);
        }
        return packageName;
    }

    protected void installAdditionalLibs(String packageName, String[] additionalLibURLs, PrintStream ... progress) throws Exception {
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to install additional libraries because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        for (String libU : additionalLibURLs) {
            if ((libU = libU.trim()).trim().length() <= 0) continue;
            URL libURL = new URL(libU.trim());
            File libPath = this.downloadArchive(libURL, "jar", progress);
            String destName = libU.substring(0, libU.lastIndexOf(".jar") + 3);
            destName = destName.substring(0, destName.lastIndexOf(46));
            destName = destName.substring(destName.lastIndexOf(47), destName.length());
            destName = destName + ".jar";
            File destDir = new File(this.m_packageHome, packageName + File.separator + "lib");
            if (!destDir.mkdir()) {
                // empty if block
            }
            File destPath = new File(destDir, destName);
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(libPath));
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destPath));
            DefaultPackageManager.copyStreams(input, output);
            ((InputStream)input).close();
            ((OutputStream)output).flush();
            ((OutputStream)output).close();
        }
    }

    @Override
    public void installPackages(List<Package> toInstall, PrintStream ... progress) throws Exception {
        File[] archivePaths = new File[toInstall.size()];
        for (int i = 0; i < toInstall.size(); ++i) {
            Package toDownload = toInstall.get(i);
            if (toDownload.isInstalled()) {
                for (PrintStream p : progress) {
                    p.println("[DefaultPackageManager] cleanining installed package: " + toDownload.getName());
                    this.uninstallPackage(toDownload.getName(), progress);
                }
            }
            archivePaths[i] = this.downloadArchive(toDownload.getPackageURL(), "zip", progress);
        }
        for (File archivePath : archivePaths) {
            this.installPackageFromArchive(archivePath.getAbsolutePath(), progress);
        }
    }

    protected static boolean checkDependencies(PackageConstraint toCheck, Map<String, Dependency> lookup, Map<String, List<Dependency>> conflicts) throws Exception {
        boolean ok = true;
        List<Dependency> deps = toCheck.getPackage().getDependencies();
        for (Dependency p : deps) {
            String depName = p.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString();
            if (!lookup.containsKey(depName)) {
                lookup.put(depName, p);
                ok = DefaultPackageManager.checkDependencies(p.getTarget(), lookup, conflicts);
                continue;
            }
            Dependency checkAgainst = lookup.get(depName);
            PackageConstraint result = checkAgainst.getTarget().checkConstraint(p.getTarget());
            if (result != null) {
                checkAgainst.setTarget(result);
                lookup.put(depName, checkAgainst);
                continue;
            }
            List<Dependency> conflictList = conflicts.get(depName);
            conflictList.add(p);
            ok = false;
        }
        return ok;
    }

    @Override
    public List<Dependency> getAllDependenciesForPackage(Package target, Map<String, List<Dependency>> conflicts) throws Exception {
        List<Dependency> initialList = target.getDependencies();
        HashMap<String, Dependency> lookup = new HashMap<String, Dependency>();
        for (Dependency d : initialList) {
            lookup.put(d.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString(), d);
            ArrayList<Dependency> deps = new ArrayList<Dependency>();
            deps.add(d);
            conflicts.put(d.getTarget().getPackage().getPackageMetaDataElement("PackageName").toString(), deps);
        }
        for (Dependency d : initialList) {
            DefaultPackageManager.checkDependencies(d.getTarget(), lookup, conflicts);
        }
        ArrayList<Dependency> fullList = new ArrayList<Dependency>(lookup.values());
        ArrayList<String> removeList = new ArrayList<String>();
        for (String key : conflicts.keySet()) {
            List<Dependency> tempD = conflicts.get(key);
            if (tempD.size() != 1) continue;
            removeList.add(key);
        }
        for (String s : removeList) {
            conflicts.remove(s);
        }
        return fullList;
    }

    @Override
    public void installPackageFromRepository(String packageName, Object version2, PrintStream ... progress) throws Exception {
        Package toInstall = this.getRepositoryPackageInfo(packageName, version2);
        if (toInstall.isInstalled()) {
            for (PrintStream p : progress) {
                p.println("[DefaultPackageManager] cleanining installed package: " + toInstall.getName());
                this.uninstallPackage(toInstall.getName(), progress);
            }
        }
        String urlString = toInstall.getPackageMetaDataElement("PackageURL").toString();
        URL packageURL = new URL(urlString);
        this.installPackageFromURL(packageURL, progress);
    }

    @Override
    public String installPackageFromURL(URL packageURL, PrintStream ... progress) throws Exception {
        File downloaded = this.downloadArchive(packageURL, "zip", progress);
        return this.installPackageFromArchive(downloaded.getAbsolutePath(), progress);
    }

    private static void copyStreams(InputStream input, OutputStream output) throws IOException {
        int count;
        byte[] data = new byte[1024];
        while ((count = input.read(data, 0, 1024)) != -1) {
            output.write(data, 0, count);
        }
    }

    protected void installPackage(String packageArchivePath, String packageName, PrintStream ... progress) throws Exception {
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to install " + packageArchivePath + " because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        File destDir = new File(this.m_packageHome, packageName);
        if (!destDir.mkdir()) {
            // empty if block
        }
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        ZipFile zipFile = new ZipFile(packageArchivePath);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) {
                new File(destDir, zipEntry.getName()).mkdirs();
                continue;
            }
            File temp = new File(destDir, zipEntry.getName()).getParentFile();
            if (temp != null && !temp.exists()) {
                temp.mkdirs();
            }
            for (PrintStream progres : progress) {
                progres.println("[DefaultPackageManager] Installing: " + zipEntry.getName());
            }
            input = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            File destFile = new File(destDir, zipEntry.getName());
            FileOutputStream fos = new FileOutputStream(destFile);
            output = new BufferedOutputStream(fos);
            DefaultPackageManager.copyStreams(input, output);
            ((InputStream)input).close();
            ((OutputStream)output).flush();
            ((OutputStream)output).close();
        }
        s_installedPackageList = null;
        this.deleteInstalledPackageCacheFile();
    }

    private URLConnection getConnection(String urlString) throws IOException {
        URL connURL = new URL(urlString);
        return this.getConnection(connURL);
    }

    private URLConnection openConnection(URL connURL) throws IOException {
        URLConnection conn = null;
        conn = this.setProxyAuthentication(connURL) ? connURL.openConnection(this.m_httpProxy) : connURL.openConnection();
        conn.setConnectTimeout(this.m_timeout);
        return conn;
    }

    private URLConnection getConnection(URL connURL) throws IOException {
        URLConnection conn = this.openConnection(connURL);
        if (conn instanceof HttpURLConnection) {
            String newURL;
            int status = 0;
            try {
                status = ((HttpURLConnection)conn).getResponseCode();
            }
            catch (Exception ex) {
                if (connURL.toString().startsWith("https://")) {
                    newURL = connURL.toString().replace("https://", "http://");
                    conn = this.openConnection(new URL(newURL));
                    status = ((HttpURLConnection)conn).getResponseCode();
                }
                throw ex;
            }
            int redirectCount = 0;
            while (status == 302 || status == 301 || status == 303) {
                if (++redirectCount > 2) {
                    throw new IOException("Three redirects were generated when trying to download " + connURL);
                }
                newURL = conn.getHeaderField("Location");
                try {
                    conn = this.openConnection(new URL(newURL));
                    status = ((HttpURLConnection)conn).getResponseCode();
                }
                catch (Exception ex) {
                    if (newURL.startsWith("https://")) {
                        System.out.println("[DefaultPackageManager] trying http instead of https for " + newURL);
                        newURL = newURL.replace("https://", "http://");
                        conn = this.openConnection(new URL(newURL));
                        status = ((HttpURLConnection)conn).getResponseCode();
                        continue;
                    }
                    throw ex;
                }
            }
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void transToBAOS(BufferedInputStream bi, ByteArrayOutputStream bos) throws Exception {
        while (true) {
            byte[] byArray = m_buffer;
            // MONITORENTER : m_buffer
            int amountRead = bi.read(m_buffer);
            if (amountRead == -1) {
                // MONITOREXIT : byArray
                bi.close();
                return;
            }
            bos.write(m_buffer, 0, amountRead);
            // MONITOREXIT : byArray
        }
    }

    private void writeZipEntryForPackage(String packageName, ZipOutputStream zos) throws Exception {
        ZipEntry packageDir = new ZipEntry(packageName + "/");
        zos.putNextEntry(packageDir);
        ZipEntry z = new ZipEntry(packageName + "/Latest.props");
        ZipEntry z2 = new ZipEntry(packageName + "/Latest.html");
        URLConnection conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/Latest.props");
        BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z);
        zos.write(bos.toByteArray());
        conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/Latest.html");
        bi = new BufferedInputStream(conn.getInputStream());
        bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z2);
        zos.write(bos.toByteArray());
        z = new ZipEntry(packageName + "/versions.txt");
        conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/versions.txt");
        bi = new BufferedInputStream(conn.getInputStream());
        bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z);
        zos.write(bos.toByteArray());
        z = new ZipEntry(packageName + "/index.html");
        conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/index.html");
        bi = new BufferedInputStream(conn.getInputStream());
        bos = new ByteArrayOutputStream();
        this.transToBAOS(bi, bos);
        zos.putNextEntry(z);
        zos.write(bos.toByteArray());
        List<Object> versions = this.getRepositoryPackageVersions(packageName);
        for (Object o : versions) {
            conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/" + o.toString() + ".props");
            z = new ZipEntry(packageName + "/" + o.toString() + ".props");
            bi = new BufferedInputStream(conn.getInputStream());
            bos = new ByteArrayOutputStream();
            this.transToBAOS(bi, bos);
            zos.putNextEntry(z);
            zos.write(bos.toByteArray());
            conn = this.getConnection(this.m_packageRepository.toString() + "/" + packageName + "/" + o.toString() + ".html");
            z = new ZipEntry(packageName + "/" + o.toString() + ".html");
            bi = new BufferedInputStream(conn.getInputStream());
            bos = new ByteArrayOutputStream();
            this.transToBAOS(bi, bos);
            zos.putNextEntry(z);
            zos.write(bos.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getRepositoryPackageMetaDataOnlyAsZip(PrintStream ... progress) throws Exception {
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        try {
            String repoZip = this.m_packageRepository.toString() + "/repo.zip";
            URLConnection conn = null;
            conn = this.getConnection(repoZip);
            BufferedInputStream bi = new BufferedInputStream(conn.getInputStream());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int totalBytesRead = 0;
            while (true) {
                byte[] byArray = m_buffer;
                // MONITORENTER : m_buffer
                int amountRead = bi.read(m_buffer);
                if (amountRead == -1) {
                    PrintStream[] arr$ = progress;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) {
                            // MONITOREXIT : byArray
                            bi.close();
                            return bos.toByteArray();
                        }
                        PrintStream progres = arr$[i$];
                        progres.println("[DefaultPackageManager] downloaded " + totalBytesRead / 1000 + " KB\r");
                        ++i$;
                    }
                }
                bos.write(m_buffer, 0, amountRead);
                totalBytesRead += amountRead;
                for (PrintStream progres : progress) {
                    progres.print("[DefaultPackageManager] downloaded " + totalBytesRead / 1000 + " KB\r");
                }
                // MONITOREXIT : byArray
            }
        }
        catch (Exception ex) {
            System.err.println("Unable to download repository zip archve (" + ex.getMessage() + ") - trying legacy routine...");
            return this.getRepositoryPackageMetaDataOnlyAsZipLegacy(progress);
        }
    }

    public byte[] getRepositoryPackageMetaDataOnlyAsZipLegacy(PrintStream ... progress) throws Exception {
        String imageName;
        String packageName;
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String packageList = this.m_packageRepository.toString() + "/packageList.txt";
        String packageListWithVersion = this.m_packageRepository.toString() + "/packageListWithVersion.txt";
        URLConnection conn = null;
        conn = this.getConnection(packageList);
        BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        while ((packageName = bi.readLine()) != null) {
            for (PrintStream p : progress) {
                p.println("Fetching meta data for " + packageName);
            }
            this.writeZipEntryForPackage(packageName, zos);
        }
        bi.close();
        conn = this.getConnection(packageList);
        ZipEntry z = new ZipEntry("packageList.txt");
        BufferedInputStream bi2 = new BufferedInputStream(conn.getInputStream());
        ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
        this.transToBAOS(bi2, bos2);
        zos.putNextEntry(z);
        zos.write(bos2.toByteArray());
        bi2.close();
        conn = this.getConnection(packageListWithVersion);
        z = new ZipEntry("packageListWithVersion.txt");
        bi2 = new BufferedInputStream(conn.getInputStream());
        bos2 = new ByteArrayOutputStream();
        this.transToBAOS(bi2, bos2);
        zos.putNextEntry(z);
        zos.write(bos2.toByteArray());
        bi2.close();
        String imageList = this.m_packageRepository.toString() + "/images.txt";
        conn = this.getConnection(imageList);
        bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((imageName = bi.readLine()) != null) {
            z = new ZipEntry(imageName);
            URLConnection conn2 = this.getConnection(this.m_packageRepository.toString() + "/" + imageName);
            bi2 = new BufferedInputStream(conn2.getInputStream());
            bos2 = new ByteArrayOutputStream();
            this.transToBAOS(bi2, bos2);
            zos.putNextEntry(z);
            zos.write(bos2.toByteArray());
            bi2.close();
        }
        conn = this.getConnection(imageList);
        z = new ZipEntry("images.txt");
        bi2 = new BufferedInputStream(conn.getInputStream());
        bos2 = new ByteArrayOutputStream();
        this.transToBAOS(bi2, bos2);
        zos.putNextEntry(z);
        zos.write(bos2.toByteArray());
        bi2.close();
        zos.close();
        return bos.toByteArray();
    }

    @Override
    public List<Package> getAllPackages(PrintStream ... progress) throws Exception {
        String packageName;
        ArrayList<Package> allPackages = new ArrayList<Package>();
        if (this.getPackageRepositoryURL() == null) {
            throw new Exception("[DefaultPackageManager] No package repository set!!");
        }
        String packageList = this.m_packageRepository.toString() + "/packageList.txt";
        URL packageListURL = new URL(packageList);
        URLConnection conn = this.getConnection(packageListURL);
        BufferedReader bi = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((packageName = bi.readLine()) != null) {
            Package temp = this.getRepositoryPackageInfo(packageName);
            allPackages.add(temp);
        }
        return allPackages;
    }

    @Override
    public List<Package> getAvailablePackages() throws Exception {
        List<Package> allP = this.getAllPackages(new PrintStream[0]);
        ArrayList<Package> available = new ArrayList<Package>();
        for (int i = 0; i < allP.size(); ++i) {
            if (allP.get(i).isInstalled()) continue;
            available.add(allP.get(i));
        }
        return available;
    }

    @Override
    public List<Package> getInstalledPackages() throws Exception {
        File[] contents;
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to get list of installed packages because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        if (s_installedPackageList != null) {
            return s_installedPackageList;
        }
        s_installedPackageList = this.loadInstalledPackageCache();
        if (s_installedPackageList != null) {
            return s_installedPackageList;
        }
        ArrayList<Package> installedP = new ArrayList<Package>();
        for (File content : contents = this.m_packageHome.listFiles()) {
            File description;
            if (!content.isDirectory() || !(description = new File(content.getAbsolutePath() + File.separator + "Description.props")).exists()) continue;
            try {
                Properties packageProperties = new Properties();
                BufferedInputStream bi = new BufferedInputStream(new FileInputStream(description));
                packageProperties.load(bi);
                bi.close();
                bi = null;
                DefaultPackage pkg = new DefaultPackage(this.m_packageHome, this, packageProperties);
                installedP.add(pkg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        s_installedPackageList = installedP;
        this.saveInstalledPackageCache(installedP);
        return installedP;
    }

    protected void deleteInstalledPackageCacheFile() throws Exception {
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to delete installed package cache file because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        File cache = new File(this.m_packageHome, INSTALLED_PACKAGE_CACHE_FILE);
        if (cache.exists() && !cache.delete()) {
            System.err.println("Unable to delete installed package cache file '" + cache.toString() + "'");
            cache.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveInstalledPackageCache(List<Package> cacheToSave) throws Exception {
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to save installed package cache file because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        try (ObjectOutputStream oos = null;){
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.m_packageHome, INSTALLED_PACKAGE_CACHE_FILE))));
            oos.writeObject(cacheToSave);
            oos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Package> loadInstalledPackageCache() throws Exception {
        if (!this.establishPackageHome()) {
            throw new Exception("Unable to load installed package cache file because package home (" + this.m_packageHome.getAbsolutePath() + ") can't be established.");
        }
        List installedP = null;
        if (new File(this.m_packageHome, INSTALLED_PACKAGE_CACHE_FILE).exists()) {
            try (ObjectInputStream ois = null;){
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(new File(this.m_packageHome.toString(), INSTALLED_PACKAGE_CACHE_FILE))));
                installedP = (List)ois.readObject();
            }
        }
        if (installedP != null) {
            for (Package p : installedP) {
                if (!(p instanceof DefaultPackage)) continue;
                ((DefaultPackage)p).setPackageManager(this);
            }
        }
        return installedP;
    }

    protected static String padLeft(String inString, int length) {
        return DefaultPackageManager.fixStringLength(inString, length, false);
    }

    protected static String padRight(String inString, int length) {
        return DefaultPackageManager.fixStringLength(inString, length, true);
    }

    private static String fixStringLength(String inString, int length, boolean right) {
        if (inString.length() < length) {
            while (inString.length() < length) {
                inString = right ? inString.concat(" ") : " ".concat(inString);
            }
        } else if (inString.length() > length) {
            inString = inString.substring(0, length);
        }
        return inString;
    }

    public static void main(String[] args) {
        try {
            URL url = new URL(args[0]);
            DefaultPackageManager pm = new DefaultPackageManager();
            pm.downloadArchive(url, args[1], System.out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static final class DefaultPMDefaults
    extends Defaults {
        protected static final String APP_ID = "defaultpackagemanager";
        protected static final Settings.SettingKey SOCKET_TIMEOUT_KEY = new Settings.SettingKey("defaultpackagemanager.timeout", "Timeout (in ms) for socket comms", "");
        protected static final int SOCKET_TIMEOUT = 5000;
        private static final long serialVersionUID = -1428588514991146709L;

        public DefaultPMDefaults() {
            super(APP_ID);
            this.m_defaults.put(SOCKET_TIMEOUT_KEY, 5000);
        }
    }
}

