/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.experiment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT2;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT3;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT4;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT6;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.experiment.Experiment;
import org.uma.jmetal.util.experiment.ExperimentBuilder;
import org.uma.jmetal.util.experiment.component.ComputeQualityIndicators;
import org.uma.jmetal.util.experiment.component.ExecuteAlgorithms;
import org.uma.jmetal.util.experiment.component.GenerateBoxplotsWithR;
import org.uma.jmetal.util.experiment.component.GenerateFriedmanTestTables;
import org.uma.jmetal.util.experiment.component.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.util.experiment.component.GenerateReferenceParetoSetAndFrontFromDoubleSolutions;
import org.uma.jmetal.util.experiment.component.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.util.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.util.experiment.util.ExperimentProblem;

public class NSGAIIStudy2 {
    private static final int INDEPENDENT_RUNS = 20;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Needed arguments: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        ArrayList<ExperimentProblem<DoubleSolution>> problemList = new ArrayList<ExperimentProblem<DoubleSolution>>();
        problemList.add(new ExperimentProblem((Problem)new ZDT1()));
        problemList.add(new ExperimentProblem((Problem)new ZDT2()));
        problemList.add(new ExperimentProblem((Problem)new ZDT3()));
        problemList.add(new ExperimentProblem((Problem)new ZDT4()));
        problemList.add(new ExperimentProblem((Problem)new ZDT6()));
        List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithmList = NSGAIIStudy2.configureAlgorithmList(problemList);
        Experiment experiment = new ExperimentBuilder("NSGAIIStudy2").setAlgorithmList(algorithmList).setProblemList(problemList).setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setReferenceFrontDirectory(experimentBaseDirectory + "/NSGAIIStudy2/referenceFronts").setIndicatorList(Arrays.asList(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus())).setIndependentRuns(20).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new GenerateReferenceParetoSetAndFrontFromDoubleSolutions(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(3).setColumns(3).run();
    }

    static List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> configureAlgorithmList(List<ExperimentProblem<DoubleSolution>> problemList) {
        ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms = new ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>>();
        for (int run = 0; run < 20; ++run) {
            NSGAII algorithm;
            int i;
            for (i = 0; i < problemList.size(); ++i) {
                algorithm = new NSGAIIBuilder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 5.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 10.0), 100).setMaxEvaluations(25000).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, "NSGAIIa", problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                algorithm = new NSGAIIBuilder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 20.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 20.0), 100).setMaxEvaluations(25000).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, "NSGAIIb", problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                algorithm = new NSGAIIBuilder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 40.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 40.0), 100).setMaxEvaluations(25000).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, "NSGAIIc", problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                algorithm = new NSGAIIBuilder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 80.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().getNumberOfVariables(), 80.0), 100).setMaxEvaluations(25000).build();
                algorithms.add((ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>)new ExperimentAlgorithm((Algorithm)algorithm, "NSGAIId", problemList.get(i), run));
            }
        }
        return algorithms;
    }
}

