/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityIndicator;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.ErrorRatio;
import org.uma.jmetal.qualityindicator.impl.GeneralizedSpread;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.SetCoverage;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.PISAHypervolume;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontNormalizer;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.point.PointSolution;

public class CommandLineIndicatorRunner {
    public static void main(String[] args) throws Exception {
        CommandLineIndicatorRunner.checkArguments(args);
        boolean normalize = CommandLineIndicatorRunner.checkAboutNormalization(args);
        CommandLineIndicatorRunner.calculateAndPrintIndicators(args, normalize);
    }

    private static void checkArguments(String[] args) {
        if (args.length != 3 && args.length != 4) {
            CommandLineIndicatorRunner.printOptions();
            throw new JMetalException("Incorrect arguments");
        }
    }

    private static boolean checkAboutNormalization(String[] args) {
        boolean normalize = false;
        if (args.length == 4) {
            if (args[3].equals("TRUE")) {
                normalize = true;
            } else if (args[3].equals("FALSE")) {
                normalize = false;
            } else {
                throw new JMetalException("The value for normalizing must be TRUE or FALSE");
            }
        }
        return normalize;
    }

    private static void printOptions() {
        JMetalLogger.logger.info("Usage: mvn -pl jmetal-exec exec:java -Dexec:mainClass=\"org.uma.jmetal.qualityIndicator.RunIndicator\"-Dexec.args=\"indicatorName referenceFront front [normalize]\" \n\nWhere indicatorValue can be one of these:\nGD   - Generational distance\nIGD  - Inverted generational distance\nIGD  - Inverted generational distance\nIGD+ - Inverted generational distance plus \nHV   - Hypervolume \nER   - Error ratio \nSPREAD  - Spread (two objectives)\nGSPREAD - Generalized Spread (more than two objectives)\nER   - Error ratio\nNormalize can be TRUE or FALSE (the fronts are normalized before computing the indicators) \n");
    }

    private static void calculateAndPrintIndicators(String[] args, boolean normalize) throws FileNotFoundException {
        ArrayFront referenceFront = new ArrayFront(args[1]);
        ArrayFront front = new ArrayFront(args[2]);
        if (normalize) {
            FrontNormalizer frontNormalizer = new FrontNormalizer((Front)referenceFront);
            referenceFront = frontNormalizer.normalize((Front)referenceFront);
            front = frontNormalizer.normalize((Front)front);
            JMetalLogger.logger.info("The fronts are NORMALIZED before computing the indicators");
        } else {
            JMetalLogger.logger.info("The fronts are NOT NORMALIZED before computing the indicators");
        }
        List<QualityIndicator<List<PointSolution>, Double>> indicatorList = CommandLineIndicatorRunner.getAvailableIndicators((Front)referenceFront);
        if (!args[0].equals("ALL")) {
            QualityIndicator<List<PointSolution>, Double> indicator = CommandLineIndicatorRunner.getIndicatorFromName(args[0], indicatorList);
            System.out.println(indicator.evaluate((Object)FrontUtils.convertFrontToSolutionList((Front)front)));
        } else {
            for (QualityIndicator<List<PointSolution>, Double> indicator : indicatorList) {
                System.out.println(indicator.getName() + ": " + indicator.evaluate((Object)FrontUtils.convertFrontToSolutionList((Front)front)));
            }
            SetCoverage sc = new SetCoverage();
            JMetalLogger.logger.info("SC(refPF, front): " + sc.evaluate(FrontUtils.convertFrontToSolutionList((Front)referenceFront), FrontUtils.convertFrontToSolutionList((Front)front)));
            JMetalLogger.logger.info("SC(front, refPF): " + sc.evaluate(FrontUtils.convertFrontToSolutionList((Front)front), FrontUtils.convertFrontToSolutionList((Front)referenceFront)));
        }
    }

    private static List<QualityIndicator<List<PointSolution>, Double>> getAvailableIndicators(Front referenceFront) throws FileNotFoundException {
        ArrayList<QualityIndicator<List<PointSolution>, Double>> list = new ArrayList<QualityIndicator<List<PointSolution>, Double>>();
        list.add((QualityIndicator<List<PointSolution>, Double>)new Epsilon(referenceFront));
        list.add((QualityIndicator<List<PointSolution>, Double>)new PISAHypervolume(referenceFront));
        list.add((QualityIndicator<List<PointSolution>, Double>)new GenerationalDistance(referenceFront));
        list.add((QualityIndicator<List<PointSolution>, Double>)new InvertedGenerationalDistance(referenceFront));
        list.add((QualityIndicator<List<PointSolution>, Double>)new InvertedGenerationalDistancePlus(referenceFront));
        list.add((QualityIndicator<List<PointSolution>, Double>)new Spread(referenceFront));
        list.add((QualityIndicator<List<PointSolution>, Double>)new GeneralizedSpread(referenceFront));
        list.add((QualityIndicator<List<PointSolution>, Double>)new ErrorRatio(referenceFront));
        return list;
    }

    private static QualityIndicator<List<PointSolution>, Double> getIndicatorFromName(String name, List<QualityIndicator<List<PointSolution>, Double>> list) {
        QualityIndicator<List<PointSolution>, Double> result = null;
        for (QualityIndicator<List<PointSolution>, Double> indicator : list) {
            if (!indicator.getName().equals(name)) continue;
            result = indicator;
        }
        if (result == null) {
            throw new JMetalException("Indicator " + name + " not available");
        }
        return result;
    }
}

