/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.abyss.ABYSS;
import org.uma.jmetal.algorithm.multiobjective.abyss.ABYSSBuilder;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;

public class ABYSSRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws Exception {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT1";
            referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/ZDT1.pf";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
        CrowdingDistanceArchive archive = new CrowdingDistanceArchive(100);
        ABYSS algorithm = new ABYSSBuilder(problem, (Archive)archive).setMaxEvaluations(25000).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        ABYSSRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            ABYSSRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

