/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.fame.FAME;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.selection.SpatialSpreadDeviationSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class FAMERunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, FileNotFoundException {
        String problemName = null;
        if (args.length == 0) {
            problemName = "org.uma.jmetal.problem.multiobjective.glt.GLT1";
        } else if (args.length == 1) {
            problemName = args[0];
        }
        Problem problem = ProblemUtils.loadProblem((String)problemName);
        SpatialSpreadDeviationSelection selection = new SpatialSpreadDeviationSelection(5);
        int populationSize = 25;
        int archiveSize = 200;
        int maxEvaluations = 45000;
        FAME algorithm = new FAME(problem, populationSize, archiveSize, maxEvaluations, (SelectionOperator)selection, (SolutionListEvaluator)new SequentialSolutionListEvaluator());
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        FAMERunner.printFinalSolutionSet((List)population);
    }
}

