/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIMeasures;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.measure.MeasureListener;
import org.uma.jmetal.util.measure.MeasureManager;
import org.uma.jmetal.util.measure.impl.BasicMeasure;
import org.uma.jmetal.util.measure.impl.DurationMeasure;

public class NSGAIIMeasuresWithHypervolumeRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, InterruptedException, FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT1";
            referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/ZDT1.pf";
        }
        Problem problem = ProblemUtils.loadProblem((String)problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        int maxEvaluations = 25000;
        int populationSize = 100;
        NSGAII algorithm = new NSGAIIBuilder(problem, (CrossoverOperator)crossover, (MutationOperator)mutation, populationSize).setSelectionOperator((SelectionOperator)selection).setMaxEvaluations(maxEvaluations).setVariant(NSGAIIBuilder.NSGAIIVariant.Measures).build();
        ((NSGAIIMeasures)algorithm).setReferenceFront((Front)new ArrayFront(referenceParetoFront));
        MeasureManager measureManager = ((NSGAIIMeasures)algorithm).getMeasureManager();
        DurationMeasure currentComputingTime = (DurationMeasure)measureManager.getPullMeasure((Object)"currentExecutionTime");
        BasicMeasure hypervolumeMeasure = (BasicMeasure)measureManager.getPushMeasure((Object)"hypervolume");
        hypervolumeMeasure.register((MeasureListener)new Listener());
        Thread algorithmThread = new Thread((Runnable)algorithm);
        algorithmThread.start();
        algorithmThread.join();
        List population = (List)algorithm.getResult();
        long computingTime = currentComputingTime.get();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        NSGAIIMeasuresWithHypervolumeRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            NSGAIIMeasuresWithHypervolumeRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }

    private static class Listener
    implements MeasureListener<Double> {
        private static int counter = 0;

        private Listener() {
        }

        public synchronized void measureGenerated(Double value) {
            if (counter++ % 10 == 0) {
                System.out.println("Hypervolume: " + value);
            }
        }
    }
}

