/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.knowm.xchart.BitmapEncoder;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.rnsgaii.RNSGAII;
import org.uma.jmetal.algorithm.multiobjective.rnsgaii.RNSGAIIBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.SBXCrossover;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.chartcontainer.ChartContainerWithReferencePoints;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.measure.MeasureListener;
import org.uma.jmetal.util.measure.MeasureManager;
import org.uma.jmetal.util.measure.impl.BasicMeasure;
import org.uma.jmetal.util.measure.impl.CountingMeasure;

public class RNSGAIIWithChartsRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, IOException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT1";
            referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/ZDT1.pf";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        ArrayList<Double> referencePoint = new ArrayList<Double>();
        referencePoint.add(0.1);
        referencePoint.add(0.6);
        referencePoint.add(0.3);
        referencePoint.add(0.6);
        referencePoint.add(0.5);
        referencePoint.add(0.2);
        referencePoint.add(0.7);
        referencePoint.add(0.2);
        referencePoint.add(0.9);
        referencePoint.add(0.0);
        double epsilon = 0.0045;
        RNSGAII algorithm = new RNSGAIIBuilder((Problem)problem, (CrossoverOperator)crossover, (MutationOperator)mutation, referencePoint, epsilon).setSelectionOperator((SelectionOperator)selection).setMaxEvaluations(25000).setPopulationSize(100).build();
        MeasureManager measureManager = algorithm.getMeasureManager();
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure((Object)"currentPopulation");
        CountingMeasure iterationMeasure = (CountingMeasure)measureManager.getPushMeasure((Object)"currentEvaluation");
        ChartContainerWithReferencePoints chart = new ChartContainerWithReferencePoints(algorithm.getName(), 80);
        chart.setFrontChart(0, 1, referenceParetoFront);
        chart.setReferencePoint(RNSGAIIWithChartsRunner.convertReferencePointListToListOfLists(referencePoint, problem.getNumberOfObjectives()));
        chart.initChart();
        solutionListMeasure.register((MeasureListener)new ChartListener(chart));
        iterationMeasure.register((MeasureListener)new IterationListener(chart));
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        chart.saveChart("RNSGAII", BitmapEncoder.BitmapFormat.PNG);
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        new SolutionListOutput(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        System.exit(0);
    }

    private static List<List<Double>> convertReferencePointListToListOfLists(List<Double> referencePoints, int numberOfObjectives) {
        ArrayList<List<Double>> referencePointList = new ArrayList<List<Double>>();
        for (int i = 0; i <= referencePoints.size() - numberOfObjectives; i += numberOfObjectives) {
            ArrayList<Double> newReferencePoint = new ArrayList<Double>(numberOfObjectives);
            for (int j = i; j < i + numberOfObjectives; ++j) {
                newReferencePoint.add(referencePoints.get(j));
            }
            referencePointList.add(newReferencePoint);
        }
        return referencePointList;
    }

    private static class IterationListener
    implements MeasureListener<Long> {
        ChartContainerWithReferencePoints chart;

        public IterationListener(ChartContainerWithReferencePoints chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: 0");
        }

        public synchronized void measureGenerated(Long iteration) {
            if (this.chart != null) {
                this.chart.getFrontChart().setTitle("Iteration: " + iteration);
            }
        }
    }

    private static class ChartListener
    implements MeasureListener<List<DoubleSolution>> {
        private ChartContainerWithReferencePoints chart;
        private int iteration = 0;

        public ChartListener(ChartContainerWithReferencePoints chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Evaluation: " + this.iteration);
        }

        private void refreshChart(List<DoubleSolution> solutionList) {
            if (this.chart != null) {
                ++this.iteration;
                this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
                this.chart.updateFrontCharts(solutionList);
                this.chart.refreshCharts();
                new SolutionListOutput(solutionList).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR." + this.iteration + ".tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN." + this.iteration + ".tsv")).print();
            }
        }

        public synchronized void measureGenerated(List<DoubleSolution> solutions) {
            this.refreshChart(solutions);
        }
    }
}

