/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.knowm.xchart.BitmapEncoder;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSORP;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.archivewithreferencepoint.ArchiveWithReferencePoint;
import org.uma.jmetal.util.archivewithreferencepoint.impl.CrowdingDistanceArchiveWithReferencePoint;
import org.uma.jmetal.util.chartcontainer.ChartContainerWithReferencePoints;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.measure.MeasureListener;
import org.uma.jmetal.util.measure.MeasureManager;
import org.uma.jmetal.util.measure.impl.BasicMeasure;
import org.uma.jmetal.util.measure.impl.CountingMeasure;

public class SMPSORPChangingTheReferencePointsAndChartsRunnerZDT1 {
    public static void main(String[] args) throws JMetalException, IOException, InterruptedException {
        ZDT1 problem = new ZDT1();
        String referenceParetoFront = null;
        ArrayList<List<Double>> referencePoints = new ArrayList<List<Double>>();
        referencePoints.add(Arrays.asList(0.0, 0.0));
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        int maxIterations = 2500000;
        int swarmSize = 100;
        ArrayList<ArchiveWithReferencePoint<DoubleSolution>> archivesWithReferencePoints = new ArrayList<ArchiveWithReferencePoint<DoubleSolution>>();
        for (int i = 0; i < referencePoints.size(); ++i) {
            archivesWithReferencePoints.add((ArchiveWithReferencePoint<DoubleSolution>)new CrowdingDistanceArchiveWithReferencePoint(swarmSize / referencePoints.size(), (List)referencePoints.get(i)));
        }
        SMPSORP algorithm = new SMPSORP((DoubleProblem)problem, swarmSize, archivesWithReferencePoints, referencePoints, (MutationOperator)mutation, maxIterations, 0.0, 1.0, 0.0, 1.0, 2.5, 1.5, 2.5, 1.5, 0.1, 0.1, -1.0, -1.0, (SolutionListEvaluator)new SequentialSolutionListEvaluator());
        MeasureManager measureManager = algorithm.getMeasureManager();
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure((Object)"currentPopulation");
        CountingMeasure iterationMeasure = (CountingMeasure)measureManager.getPushMeasure((Object)"currentIteration");
        ChartContainerWithReferencePoints chart = new ChartContainerWithReferencePoints(algorithm.getName(), 300);
        chart.setFrontChart(0, 1, referenceParetoFront);
        chart.setReferencePoint(referencePoints);
        chart.initChart();
        solutionListMeasure.register((MeasureListener)new ChartListener(chart));
        iterationMeasure.register((MeasureListener)new IterationListener(chart));
        Thread algorithmThread = new Thread((Runnable)algorithm);
        ChangeReferencePoint changeReferencePoint = new ChangeReferencePoint((Algorithm<List<DoubleSolution>>)algorithm, referencePoints, archivesWithReferencePoints, chart);
        Thread changePointsThread = new Thread(changeReferencePoint);
        algorithmThread.start();
        changePointsThread.start();
        algorithmThread.join();
        chart.saveChart("RSMPSO", BitmapEncoder.BitmapFormat.PNG);
        List population = (List)algorithm.getResult();
        new SolutionListOutput(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        for (int i = 0; i < archivesWithReferencePoints.size(); ++i) {
            new SolutionListOutput(((ArchiveWithReferencePoint)archivesWithReferencePoints.get(i)).getSolutionList()).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR" + i + ".tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN" + i + ".tsv")).print();
        }
        System.out.println("FINISH");
        System.exit(0);
    }

    private static class ChangeReferencePoint
    implements Runnable {
        ChartContainerWithReferencePoints chart;
        List<List<Double>> referencePoints;
        SMPSORP algorithm;

        public ChangeReferencePoint(Algorithm<List<DoubleSolution>> algorithm, List<List<Double>> referencePoints, List<ArchiveWithReferencePoint<DoubleSolution>> archivesWithReferencePoints, ChartContainerWithReferencePoints chart) throws InterruptedException {
            this.referencePoints = referencePoints;
            this.chart = chart;
            this.algorithm = (SMPSORP)algorithm;
        }

        @Override
        public void run() {
            Scanner scanner = new Scanner(System.in);
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        System.out.println("Introduce the new reference point (between commas):");
                        String s = scanner.nextLine();
                        try (Scanner sl = new Scanner(s);){
                            sl.useDelimiter(",");
                            for (int i = 0; i < this.referencePoints.size(); ++i) {
                                double v2;
                                double v1;
                                try {
                                    v1 = Double.parseDouble(sl.next());
                                    v2 = Double.parseDouble(sl.next());
                                }
                                catch (Exception e) {
                                    v1 = 0.0;
                                    v2 = 0.0;
                                }
                                this.referencePoints.get(i).set(0, v1);
                                this.referencePoints.get(i).set(1, v2);
                            }
                        }
                        this.chart.updateReferencePoint(this.referencePoints);
                        this.algorithm.changeReferencePoints(this.referencePoints);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (scanner != null) {
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        scanner.close();
                    }
                }
                throw throwable3;
            }
        }
    }

    private static class IterationListener
    implements MeasureListener<Long> {
        ChartContainerWithReferencePoints chart;

        public IterationListener(ChartContainerWithReferencePoints chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: 0");
        }

        public synchronized void measureGenerated(Long iteration) {
            if (this.chart != null) {
                this.chart.getFrontChart().setTitle("Iteration: " + iteration);
            }
        }
    }

    private static class ChartListener
    implements MeasureListener<List<DoubleSolution>> {
        private ChartContainerWithReferencePoints chart;
        private int iteration = 0;

        public ChartListener(ChartContainerWithReferencePoints chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
        }

        private void refreshChart(List<DoubleSolution> solutionList) {
            if (this.chart != null) {
                ++this.iteration;
                this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
                this.chart.updateFrontCharts(solutionList);
                this.chart.refreshCharts();
            }
        }

        public synchronized void measureGenerated(List<DoubleSolution> solutions) {
            this.refreshChart(solutions);
        }
    }
}

