/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.knowm.xchart.BitmapEncoder;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSORP;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.impl.mutation.PolynomialMutation;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.archivewithreferencepoint.ArchiveWithReferencePoint;
import org.uma.jmetal.util.archivewithreferencepoint.impl.CrowdingDistanceArchiveWithReferencePoint;
import org.uma.jmetal.util.chartcontainer.ChartContainerWithReferencePoints;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.measure.MeasureListener;
import org.uma.jmetal.util.measure.MeasureManager;
import org.uma.jmetal.util.measure.impl.BasicMeasure;
import org.uma.jmetal.util.measure.impl.CountingMeasure;

public class SMPSORPWithMultipleReferencePointsAndChartsRunner {
    public static void main(String[] args) throws JMetalException, IOException {
        String problemName;
        String referenceParetoFront = "";
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT1";
            referenceParetoFront = "jmetal-problem/src/test/resources/pareto_fronts/ZDT1.pf";
        }
        DoubleProblem problem = (DoubleProblem)ProblemUtils.loadProblem((String)problemName);
        ArrayList<List<Double>> referencePoints = new ArrayList<List<Double>>();
        referencePoints.add(Arrays.asList(0.2, 0.3));
        referencePoints.add(Arrays.asList(0.8, 0.2));
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        int maxIterations = 250;
        int swarmSize = 100;
        ArrayList<CrowdingDistanceArchiveWithReferencePoint> archivesWithReferencePoints = new ArrayList<CrowdingDistanceArchiveWithReferencePoint>();
        for (int i = 0; i < referencePoints.size(); ++i) {
            archivesWithReferencePoints.add(new CrowdingDistanceArchiveWithReferencePoint(swarmSize / referencePoints.size(), (List)referencePoints.get(i)));
        }
        SMPSORP algorithm = new SMPSORP(problem, swarmSize, archivesWithReferencePoints, referencePoints, (MutationOperator)mutation, maxIterations, 0.0, 1.0, 0.0, 1.0, 2.5, 1.5, 2.5, 1.5, 0.1, 0.1, -1.0, -1.0, (SolutionListEvaluator)new SequentialSolutionListEvaluator());
        MeasureManager measureManager = algorithm.getMeasureManager();
        BasicMeasure solutionListMeasure = (BasicMeasure)measureManager.getPushMeasure((Object)"currentPopulation");
        CountingMeasure iterationMeasure = (CountingMeasure)measureManager.getPushMeasure((Object)"currentIteration");
        ChartContainerWithReferencePoints chart = new ChartContainerWithReferencePoints(algorithm.getName(), 80);
        chart.setFrontChart(0, 1, referenceParetoFront);
        chart.setReferencePoint(referencePoints);
        chart.initChart();
        solutionListMeasure.register((MeasureListener)new ChartListener(chart));
        iterationMeasure.register((MeasureListener)new IterationListener(chart));
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        chart.saveChart("SMPSORP", BitmapEncoder.BitmapFormat.PNG);
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        new SolutionListOutput(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        for (int i = 0; i < archivesWithReferencePoints.size(); ++i) {
            new SolutionListOutput(((ArchiveWithReferencePoint)archivesWithReferencePoints.get(i)).getSolutionList()).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR" + i + ".tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN" + i + ".tsv")).print();
        }
        System.exit(0);
    }

    private static class IterationListener
    implements MeasureListener<Long> {
        ChartContainerWithReferencePoints chart;

        public IterationListener(ChartContainerWithReferencePoints chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: 0");
        }

        public synchronized void measureGenerated(Long iteration) {
            if (this.chart != null) {
                this.chart.getFrontChart().setTitle("Iteration: " + iteration);
            }
        }
    }

    private static class ChartListener
    implements MeasureListener<List<DoubleSolution>> {
        private ChartContainerWithReferencePoints chart;
        private int iteration = 0;

        public ChartListener(ChartContainerWithReferencePoints chart) {
            this.chart = chart;
            this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
        }

        private void refreshChart(List<DoubleSolution> solutionList) {
            if (this.chart != null) {
                ++this.iteration;
                this.chart.getFrontChart().setTitle("Iteration: " + this.iteration);
                this.chart.updateFrontCharts(solutionList);
                this.chart.refreshCharts();
                new SolutionListOutput(solutionList).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR." + this.iteration + ".tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN." + this.iteration + ".tsv")).print();
            }
        }

        public synchronized void measureGenerated(List<DoubleSolution> solutions) {
            this.refreshChart(solutions);
        }
    }
}

