/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.multiobjective;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.multiobjective.wasfga.WASFGA;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.SinglePointCrossover;
import org.uma.jmetal.operator.impl.mutation.BitFlipMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.ProblemUtils;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class WASFGABinaryRunner
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, FileNotFoundException {
        String problemName;
        String referenceParetoFront = "";
        ArrayList<Double> referencePoint = null;
        if (args.length == 1) {
            problemName = args[0];
        } else if (args.length == 2) {
            problemName = args[0];
            referenceParetoFront = args[1];
        } else {
            problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT5";
        }
        BinaryProblem problem = (BinaryProblem)ProblemUtils.loadProblem((String)problemName);
        referencePoint = new ArrayList<Double>();
        referencePoint.add(10.0);
        referencePoint.add(4.0);
        double crossoverProbability = 0.9;
        SinglePointCrossover crossover = new SinglePointCrossover(crossoverProbability);
        double mutationProbability = 1.0 / (double)problem.getNumberOfBits(0);
        BitFlipMutation mutation = new BitFlipMutation(mutationProbability);
        BinaryTournamentSelection selection = new BinaryTournamentSelection();
        double epsilon = 0.01;
        WASFGA algorithm = new WASFGA((Problem)problem, 100, 250, (CrossoverOperator)crossover, (MutationOperator)mutation, (SelectionOperator)selection, (SolutionListEvaluator)new SequentialSolutionListEvaluator(), epsilon, referencePoint);
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor((Algorithm)algorithm).execute();
        List population = (List)algorithm.getResult();
        long computingTime = algorithmRunner.getComputingTime();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        WASFGABinaryRunner.printFinalSolutionSet((List)population);
        if (!referenceParetoFront.equals("")) {
            WASFGABinaryRunner.printQualityIndicators((List)population, (String)referenceParetoFront);
        }
    }
}

