/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.runner.singleobjective;

import java.util.ArrayList;
import java.util.Comparator;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.algorithm.singleobjective.geneticalgorithm.GeneticAlgorithmBuilder;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.operator.impl.crossover.PMXCrossover;
import org.uma.jmetal.operator.impl.mutation.PermutationSwapMutation;
import org.uma.jmetal.operator.impl.selection.BinaryTournamentSelection;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.singleobjective.TSP;
import org.uma.jmetal.solution.PermutationSolution;
import org.uma.jmetal.util.AlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.RankingAndCrowdingDistanceComparator;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class GenerationalGeneticAlgorithmTSPRunner {
    public static void main(String[] args) throws Exception {
        TSP problem = new TSP("/tspInstances/kroA100.tsp");
        PMXCrossover crossover = new PMXCrossover(0.9);
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        PermutationSwapMutation mutation = new PermutationSwapMutation(mutationProbability);
        BinaryTournamentSelection selection = new BinaryTournamentSelection((Comparator)new RankingAndCrowdingDistanceComparator());
        Algorithm algorithm = new GeneticAlgorithmBuilder((Problem)problem, (CrossoverOperator)crossover, (MutationOperator)mutation).setPopulationSize(100).setMaxEvaluations(250000).setSelectionOperator((SelectionOperator)selection).build();
        AlgorithmRunner algorithmRunner = new AlgorithmRunner.Executor(algorithm).execute();
        PermutationSolution solution = (PermutationSolution)algorithm.getResult();
        ArrayList<PermutationSolution> population = new ArrayList<PermutationSolution>(1);
        population.add(solution);
        long computingTime = algorithmRunner.getComputingTime();
        new SolutionListOutput(population).setSeparator("\t").setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.tsv")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.tsv")).print();
        JMetalLogger.logger.info("Total execution time: " + computingTime + "ms");
        JMetalLogger.logger.info("Objectives values have been written to file FUN.tsv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.tsv");
    }
}

