/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment;

import java.util.HashSet;
import java.util.List;
import org.uma.jmetal.lab.experiment.ExperimentBuilder;
import org.uma.jmetal.lab.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;

public class Experiment<S extends Solution<?>, Result extends List<S>> {
    private String experimentName;
    private List<ExperimentAlgorithm<S, Result>> algorithmList;
    private List<ExperimentProblem<S>> problemList;
    private String experimentBaseDirectory;
    private String outputParetoFrontFileName;
    private String outputParetoSetFileName;
    private int independentRuns;
    private String referenceFrontDirectory;
    private List<QualityIndicator> indicatorList;
    private int numberOfCores;

    public Experiment(ExperimentBuilder<S, Result> builder) {
        this.experimentName = builder.getExperimentName();
        this.experimentBaseDirectory = builder.getExperimentBaseDirectory();
        this.algorithmList = builder.getAlgorithmList();
        this.problemList = builder.getProblemList();
        this.independentRuns = builder.getIndependentRuns();
        this.outputParetoFrontFileName = builder.getOutputParetoFrontFileName();
        this.outputParetoSetFileName = builder.getOutputParetoSetFileName();
        this.numberOfCores = builder.getNumberOfCores();
        this.referenceFrontDirectory = builder.getReferenceFrontDirectory();
        this.indicatorList = builder.getIndicatorList();
    }

    public String getExperimentName() {
        return this.experimentName;
    }

    public List<ExperimentAlgorithm<S, Result>> getAlgorithmList() {
        return this.algorithmList;
    }

    public List<ExperimentProblem<S>> getProblemList() {
        return this.problemList;
    }

    public String getExperimentBaseDirectory() {
        return this.experimentBaseDirectory;
    }

    public String getOutputParetoFrontFileName() {
        return this.outputParetoFrontFileName;
    }

    public String getOutputParetoSetFileName() {
        return this.outputParetoSetFileName;
    }

    public int getIndependentRuns() {
        return this.independentRuns;
    }

    public int getNumberOfCores() {
        return this.numberOfCores;
    }

    public String getReferenceFrontDirectory() {
        return this.referenceFrontDirectory;
    }

    public List<QualityIndicator> getIndicatorList() {
        return this.indicatorList;
    }

    public void setReferenceFrontDirectory(String referenceFrontDirectory) {
        this.referenceFrontDirectory = referenceFrontDirectory;
    }

    public void setAlgorithmList(List<ExperimentAlgorithm<S, Result>> algorithmList) {
        this.algorithmList = algorithmList;
    }

    public void removeDuplicatedAlgorithms() {
        HashSet algorithmTagList = new HashSet();
        this.getAlgorithmList().removeIf(alg -> !algorithmTagList.add(alg.getAlgorithmTag()));
    }
}

