/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.component.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.component.ExperimentComponent;
import org.uma.jmetal.lab.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.NormalizeUtils;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class ComputeQualityIndicators<S extends Solution<?>, Result extends List<S>>
implements ExperimentComponent {
    private final Experiment<S, Result> experiment;

    public ComputeQualityIndicators(Experiment<S, Result> experiment) {
        this.experiment = experiment;
    }

    @Override
    public void run() throws IOException {
        this.experiment.removeDuplicatedAlgorithms();
        this.resetIndicatorFiles();
        for (QualityIndicator indicator : this.experiment.getIndicatorList()) {
            JMetalLogger.logger.info("Computing indicator: " + indicator.getName());
            for (ExperimentAlgorithm<S, Result> algorithm : this.experiment.getAlgorithmList()) {
                String algorithmDirectory = this.experiment.getExperimentBaseDirectory() + "/data/" + algorithm.getAlgorithmTag();
                for (ExperimentProblem<S> problem : this.experiment.getProblemList()) {
                    String problemDirectory = algorithmDirectory + "/" + problem.getTag();
                    String referenceFrontDirectory = this.experiment.getReferenceFrontDirectory();
                    String referenceFrontName = referenceFrontDirectory + "/" + problem.getReferenceFront();
                    JMetalLogger.logger.info("RF: " + referenceFrontName);
                    double[][] referenceFront = VectorUtils.readVectors((String)referenceFrontName, (String)",");
                    double[][] normalizedReferenceFront = NormalizeUtils.normalize((double[][])referenceFront);
                    indicator.setReferenceFront(normalizedReferenceFront);
                    String qualityIndicatorFile = problemDirectory + "/" + indicator.getName();
                    double[] indicatorValues = new double[this.experiment.getIndependentRuns()];
                    IntStream.range(0, this.experiment.getIndependentRuns()).forEach(run -> {
                        String frontFileName = problemDirectory + "/" + this.experiment.getOutputParetoFrontFileName() + run + ".csv";
                        Object front = new double[][]{};
                        try {
                            front = VectorUtils.readVectors((String)frontFileName, (String)",");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        double[][] normalizedFront = NormalizeUtils.normalize((double[][])front, (double[])NormalizeUtils.getMinValuesOfTheColumnsOfAMatrix((double[][])referenceFront), (double[])NormalizeUtils.getMaxValuesOfTheColumnsOfAMatrix((double[][])referenceFront));
                        Double indicatorValue = indicator.compute(normalizedFront);
                        JMetalLogger.logger.info(indicator.getName() + ": " + indicatorValue);
                        indicatorValues[run] = indicatorValue;
                    });
                    for (double indicatorValue : indicatorValues) {
                        this.writeQualityIndicatorValueToFile(indicatorValue, qualityIndicatorFile);
                    }
                }
            }
        }
        this.findBestIndicatorFronts(this.experiment);
        this.writeSummaryFile(this.experiment);
    }

    private void writeQualityIndicatorValueToFile(Double indicatorValue, String qualityIndicatorFile) {
        try (FileWriter os = new FileWriter(qualityIndicatorFile, true);){
            os.write(indicatorValue + "\n");
        }
        catch (IOException ex) {
            throw new JMetalException("Error writing indicator file" + ex);
        }
    }

    public void findBestIndicatorFronts(Experiment<?, Result> experiment) throws IOException {
        for (QualityIndicator indicator : experiment.getIndicatorList()) {
            for (ExperimentAlgorithm<?, Result> algorithm : experiment.getAlgorithmList()) {
                String algorithmDirectory = experiment.getExperimentBaseDirectory() + "/data/" + algorithm.getAlgorithmTag();
                for (ExperimentProblem<?> problem : experiment.getProblemList()) {
                    String bestVarFile;
                    String bestFunFile;
                    String indicatorFileName = algorithmDirectory + "/" + problem.getTag() + "/" + indicator.getName();
                    Path indicatorFile = Paths.get(indicatorFileName, new String[0]);
                    List<String> fileArray = Files.readAllLines(indicatorFile, StandardCharsets.UTF_8);
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < fileArray.size(); ++i) {
                        ImmutablePair pair2 = new ImmutablePair((Object)Double.parseDouble(fileArray.get(i)), (Object)i);
                        list.add(pair2);
                    }
                    list.sort(Comparator.comparingDouble(pair -> Math.abs((Double)pair.getLeft())));
                    String outputDirectory = algorithmDirectory + "/" + problem.getTag();
                    String bestFunFileName = outputDirectory + "/BEST_" + indicator.getName() + "_FUN.csv";
                    String bestVarFileName = outputDirectory + "/BEST_" + indicator.getName() + "_VAR.csv";
                    String medianFunFileName = outputDirectory + "/MEDIAN_" + indicator.getName() + "_FUN.csv";
                    String medianVarFileName = outputDirectory + "/MEDIAN_" + indicator.getName() + "_VAR.csv";
                    if (indicator.isTheLowerTheIndicatorValueTheBetter()) {
                        bestFunFile = outputDirectory + "/" + experiment.getOutputParetoFrontFileName() + ((Pair)list.get(0)).getRight() + ".csv";
                        bestVarFile = outputDirectory + "/" + experiment.getOutputParetoSetFileName() + ((Pair)list.get(0)).getRight() + ".csv";
                        Files.copy(Paths.get(bestFunFile, new String[0]), Paths.get(bestFunFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        Files.copy(Paths.get(bestVarFile, new String[0]), Paths.get(bestVarFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        bestFunFile = outputDirectory + "/" + experiment.getOutputParetoFrontFileName() + ((Pair)list.get(list.size() - 1)).getRight() + ".csv";
                        bestVarFile = outputDirectory + "/" + experiment.getOutputParetoSetFileName() + ((Pair)list.get(list.size() - 1)).getRight() + ".csv";
                        Files.copy(Paths.get(bestFunFile, new String[0]), Paths.get(bestFunFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        Files.copy(Paths.get(bestVarFile, new String[0]), Paths.get(bestVarFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    }
                    int medianIndex = list.size() / 2;
                    String medianFunFile = outputDirectory + "/" + experiment.getOutputParetoFrontFileName() + ((Pair)list.get(medianIndex)).getRight() + ".csv";
                    String medianVarFile = outputDirectory + "/" + experiment.getOutputParetoSetFileName() + ((Pair)list.get(medianIndex)).getRight() + ".csv";
                    Files.copy(Paths.get(medianFunFile, new String[0]), Paths.get(medianFunFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(Paths.get(medianVarFile, new String[0]), Paths.get(medianVarFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
    }

    private void resetIndicatorFiles() {
        for (QualityIndicator indicator : this.experiment.getIndicatorList()) {
            for (ExperimentAlgorithm<S, Result> algorithm : this.experiment.getAlgorithmList()) {
                for (ExperimentProblem<S> problem : this.experiment.getProblemList()) {
                    String algorithmDirectory = this.experiment.getExperimentBaseDirectory() + "/data/" + algorithm.getAlgorithmTag();
                    String problemDirectory = algorithmDirectory + "/" + problem.getTag();
                    String qualityIndicatorFile = problemDirectory + "/" + indicator.getName();
                    this.resetFile(qualityIndicatorFile);
                }
            }
        }
    }

    private void resetFile(String file) {
        File f = new File(file);
        if (f.exists()) {
            JMetalLogger.logger.info("Already existing file " + file);
            if (f.isDirectory()) {
                JMetalLogger.logger.info("Deleting directory " + file);
                if (f.delete()) {
                    JMetalLogger.logger.info("Directory successfully deleted.");
                } else {
                    JMetalLogger.logger.info("Error deleting directory.");
                }
            } else {
                JMetalLogger.logger.info("Deleting file " + file);
                if (f.delete()) {
                    JMetalLogger.logger.info("File successfully deleted.");
                } else {
                    JMetalLogger.logger.info("Error deleting file.");
                }
            }
        } else {
            JMetalLogger.logger.info("File " + file + " does NOT exist.");
        }
    }

    private void writeSummaryFile(Experiment<S, Result> experiment) {
        JMetalLogger.logger.info("Writing org.uma.jmetal.experiment summary file");
        String headerOfCSVFile = "Algorithm,Problem,IndicatorName,ExecutionId,IndicatorValue";
        String csvFileName = this.experiment.getExperimentBaseDirectory() + "/QualityIndicatorSummary.csv";
        this.resetFile(csvFileName);
        try (FileWriter os = new FileWriter(csvFileName, true);){
            os.write(headerOfCSVFile + "\n");
            for (QualityIndicator indicator : experiment.getIndicatorList()) {
                for (ExperimentAlgorithm<S, Result> algorithm : experiment.getAlgorithmList()) {
                    String algorithmDirectory = experiment.getExperimentBaseDirectory() + "/data/" + algorithm.getAlgorithmTag();
                    for (ExperimentProblem<S> problem : experiment.getProblemList()) {
                        String indicatorFileName = algorithmDirectory + "/" + problem.getTag() + "/" + indicator.getName();
                        Path indicatorFile = Paths.get(indicatorFileName, new String[0]);
                        if (indicatorFile == null) {
                            throw new JMetalException("Indicator file " + indicator.getName() + " doesn't exist");
                        }
                        System.out.println("-----");
                        System.out.println(indicatorFileName);
                        List<String> fileArray = Files.readAllLines(indicatorFile, StandardCharsets.UTF_8);
                        System.out.println(fileArray);
                        System.out.println("++++++");
                        for (int i = 0; i < fileArray.size(); ++i) {
                            String row = algorithm.getAlgorithmTag() + "," + problem.getTag() + "," + indicator.getName() + "," + i + "," + fileArray.get(i);
                            os.write(row + "\n");
                        }
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new JMetalException("Error writing indicator file" + ex);
        }
    }
}

