/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.component.impl;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.component.ExperimentComponent;
import org.uma.jmetal.lab.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class ExecuteAlgorithms<S extends Solution<?>, Result extends List<S>>
implements ExperimentComponent {
    private Experiment<S, Result> experiment;

    public ExecuteAlgorithms(Experiment<S, Result> configuration) {
        this.experiment = configuration;
    }

    @Override
    public void run() {
        JMetalLogger.logger.info("ExecuteAlgorithms: Preparing output directory");
        this.prepareOutputDirectory();
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "" + this.experiment.getNumberOfCores());
        int retryCounter = 0;
        int maxRetries = 5;
        boolean computationNotFinished = true;
        while (computationNotFinished && retryCounter < maxRetries) {
            List<ExperimentAlgorithm<?, ?>> unfinishedAlgorithmList = this.checkTaskStatus();
            if (unfinishedAlgorithmList.size() == 0) {
                computationNotFinished = false;
                continue;
            }
            JMetalLogger.logger.info("ExecuteAlgorithms: there are " + unfinishedAlgorithmList.size() + " runs pending");
            unfinishedAlgorithmList.parallelStream().forEach(algorithm -> algorithm.runAlgorithm(this.experiment));
            ++retryCounter;
        }
        if (computationNotFinished) {
            JMetalLogger.logger.severe("There are unfinished tasks after " + maxRetries + " tries");
        } else {
            JMetalLogger.logger.info("Algorithm runs finished. Number of tries: " + retryCounter);
        }
    }

    public List<ExperimentAlgorithm<?, ?>> checkTaskStatus() {
        LinkedList unfinishedAlgorithmList = new LinkedList();
        for (ExperimentAlgorithm<S, Result> algorithm : this.experiment.getAlgorithmList()) {
            String resultFileName = this.experiment.getExperimentBaseDirectory() + "/data/" + algorithm.getAlgorithmTag() + "/" + algorithm.getProblemTag() + "/" + this.experiment.getOutputParetoFrontFileName() + algorithm.getRunId() + ".csv";
            File file = new File(resultFileName);
            if (file.exists()) continue;
            unfinishedAlgorithmList.add(algorithm);
            System.out.println(resultFileName + ". Status: " + file.exists());
        }
        return unfinishedAlgorithmList;
    }

    public void runMissingExecutions(List<ExperimentAlgorithm<?, ?>> experimentAlgorithms) {
        experimentAlgorithms.parallelStream().forEach(algorithm -> algorithm.runAlgorithm(this.experiment));
    }

    private void prepareOutputDirectory() {
        if (this.experimentDirectoryDoesNotExist()) {
            this.createExperimentDirectory();
        }
    }

    private boolean experimentDirectoryDoesNotExist() {
        File experimentDirectory = new File(this.experiment.getExperimentBaseDirectory());
        boolean result = !experimentDirectory.exists() || !experimentDirectory.isDirectory();
        return result;
    }

    private void createExperimentDirectory() {
        boolean result;
        File experimentDirectory = new File(this.experiment.getExperimentBaseDirectory());
        if (experimentDirectory.exists()) {
            experimentDirectory.delete();
        }
        if (!(result = new File(this.experiment.getExperimentBaseDirectory()).mkdirs())) {
            throw new JMetalException("Error creating org.uma.jmetal.experiment directory: " + this.experiment.getExperimentBaseDirectory());
        }
    }
}

