/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.component.impl;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.component.ExperimentComponent;
import org.uma.jmetal.lab.experiment.util.FriedmanTest;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.JMetalException;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;

public class GenerateFriedmanHolmTestTables<Result extends List<? extends Solution<?>>>
implements ExperimentComponent {
    private static final String DEFAULT_LATEX_DIRECTORY = "latex";
    private static final String INDICATOR_SUMMARY_CSV = "QualityIndicatorSummary.csv";
    private static final String ALGORITHM = "Algorithm";
    private static final String PROBLEM = "Problem";
    private static final String INDICATOR_NAME = "IndicatorName";
    private final Experiment<?, Result> experiment;
    private String latexDirectoryName;
    private int numberOfAlgorithms;
    private int numberOfProblems;

    public GenerateFriedmanHolmTestTables(Experiment<?, Result> experimentConfiguration) {
        this.experiment = experimentConfiguration;
        this.numberOfAlgorithms = this.experiment.getAlgorithmList().size();
        this.numberOfProblems = this.experiment.getProblemList().size();
        this.experiment.removeDuplicatedAlgorithms();
    }

    @Override
    public void run() throws IOException {
        this.latexDirectoryName = this.experiment.getExperimentBaseDirectory() + "/latex";
        String path = this.experiment.getExperimentBaseDirectory();
        Table table = Table.read().csv(path + "/QualityIndicatorSummary.csv");
        boolean minimizar = true;
        for (QualityIndicator indicator : this.experiment.getIndicatorList()) {
            Table tableFilteredByIndicator = this.filterTableByIndicator(table, indicator.getName());
            if (indicator.getName().equals("HV")) {
                minimizar = false;
            }
            Table results = this.computeFriedmanAndHolmTests(tableFilteredByIndicator, minimizar);
            this.createLatexFile(results, indicator);
        }
    }

    private Table computeFriedmanAndHolmTests(Table table, boolean minimizar) {
        StringColumn algorithms = this.getUniquesValuesOfStringColumn(table, ALGORITHM);
        StringColumn problems = this.getUniquesValuesOfStringColumn(table, PROBLEM);
        FriedmanTest test = new FriedmanTest(minimizar, table, algorithms, problems, "IndicatorValue");
        test.computeHolmTest();
        return test.getResults();
    }

    private void createLatexFile(Table results, QualityIndicator indicator) {
        String outputFile = this.latexDirectoryName + "/FriedmanTestWithHolm" + indicator.getName() + ".tex";
        File latexOutput = new File(this.latexDirectoryName);
        if (!latexOutput.exists()) {
            latexOutput.mkdirs();
        }
        String fileContents = this.prepareFileOutputContents(results);
        try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(outputFile));){
            dataOutputStream.writeBytes(fileContents);
        }
        catch (IOException e) {
            throw new JMetalException("Error writing data ", (Exception)e);
        }
    }

    public String prepareFileOutputContents(Table results) {
        String fileContents = this.writeLatexHeader();
        fileContents = this.printTableHeader(fileContents);
        fileContents = this.printTableLines(fileContents, results);
        fileContents = this.printTableTail(fileContents);
        fileContents = this.printDocumentFooter(fileContents, results.doubleColumn("Ranking").asDoubleArray());
        return fileContents;
    }

    private String writeLatexHeader() {
        return "\\documentclass{article}\n\\usepackage{graphicx}\n\\title{Results}\n\\author{}\n\\date{\\today}\n\\begin{document}\n\\oddsidemargin 0in \\topmargin 0in\\maketitle\n\n\\section{Tables}";
    }

    private String printTableHeader(String fileContents) {
        return fileContents + "\n\\begin{table}[!htp]\n\\centering\n\\begin{tabular}{c|c|c|c|c}\nAlgorithm&Ranking&p-value&Holm&Hypothesis\\\\\n\\hline";
    }

    private String printTableLines(String fileContents, Table results) {
        StringBuilder sb = new StringBuilder(fileContents);
        for (int i = 0; i < results.rowCount(); ++i) {
            sb.append("\n");
            for (int j = 0; j < results.columnCount(); ++j) {
                DecimalFormat format;
                if (j == results.columnIndex(ALGORITHM)) {
                    sb.append(results.stringColumn(0).get(i));
                } else if (j == results.columnIndex("Hypothesis")) {
                    sb.append(results.stringColumn(j).get(i));
                } else if (j == results.columnIndex("p-value")) {
                    format = new DecimalFormat("0.###E0");
                    sb.append(format.format(results.doubleColumn(j).get(i)));
                } else {
                    format = new DecimalFormat("##.###");
                    sb.append(format.format(results.doubleColumn(j).get(i)));
                }
                if (j >= results.columnCount() - 1) continue;
                sb.append(" & ");
            }
            sb.append("\\\\");
        }
        return sb.toString();
    }

    private String printTableTail(String fileContents) {
        return fileContents + "\n\\end{tabular}\n\\caption{Average ranking of the algorithms}\n\\end{table}";
    }

    private String printDocumentFooter(String fileContents, double[] averageRanking) {
        double term1 = 12.0 * (double)this.numberOfProblems / (double)(this.numberOfAlgorithms * (this.numberOfAlgorithms + 1));
        double term2 = (double)(this.numberOfAlgorithms * (this.numberOfAlgorithms + 1) * (this.numberOfAlgorithms + 1)) / 4.0;
        double sum = 0.0;
        for (int i = 0; i < this.numberOfAlgorithms; ++i) {
            sum += averageRanking[i] * averageRanking[i];
        }
        double friedman = (sum - term2) * term1;
        String output = fileContents + "\n\n\nFriedman statistic considering reduction performance (distributed according to chi-square with " + (this.numberOfAlgorithms - 1) + " degrees of freedom: " + friedman + ").\n\n";
        output = output + "\n\\end{document}";
        return output;
    }

    private StringColumn getUniquesValuesOfStringColumn(Table table, String columnName) {
        return this.dropDuplicateRowsInColumn(table.stringColumn(columnName));
    }

    public StringColumn dropDuplicateRowsInColumn(StringColumn column) {
        LinkedList<String> result = new LinkedList<String>();
        for (int row = 0; row < column.size(); ++row) {
            if (result.contains(column.get(row))) continue;
            result.add(column.get(row));
        }
        return StringColumn.create((String)column.name(), result);
    }

    private Table filterTableByIndicator(Table table, String indicator) {
        return table.where(table.stringColumn(INDICATOR_NAME).isEqualTo(indicator));
    }
}

