/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.component.impl;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.component.ExperimentComponent;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class GenerateFriedmanTestTables<Result extends List<? extends Solution<?>>>
implements ExperimentComponent {
    private static final String DEFAULT_LATEX_DIRECTORY = "latex";
    private final Experiment<?, Result> experiment;
    private String latexDirectoryName;
    private int numberOfAlgorithms;
    private int numberOfProblems;

    public GenerateFriedmanTestTables(Experiment<?, Result> experimentConfiguration) {
        this.experiment = experimentConfiguration;
        this.numberOfAlgorithms = this.experiment.getAlgorithmList().size();
        this.numberOfProblems = this.experiment.getProblemList().size();
        this.experiment.removeDuplicatedAlgorithms();
    }

    @Override
    public void run() throws IOException {
        this.latexDirectoryName = this.experiment.getExperimentBaseDirectory() + "/latex";
        for (QualityIndicator indicator : this.experiment.getIndicatorList()) {
            Vector<Vector<Double>> data = this.readData(indicator);
            double[] averageRanking = this.computeAverageRanking(data);
            String fileContents = this.prepareFileOutputContents(averageRanking);
            this.writeLatexFile(indicator, fileContents);
        }
    }

    private Vector<Vector<Double>> readData(QualityIndicator indicator) {
        Vector<Vector<Double>> data = new Vector<Vector<Double>>();
        for (int algorithm = 0; algorithm < this.experiment.getAlgorithmList().size(); ++algorithm) {
            String algorithmName = this.experiment.getAlgorithmList().get(algorithm).getAlgorithmTag();
            data.add(new Vector());
            String algorithmPath = this.experiment.getExperimentBaseDirectory() + "/data/" + algorithmName + "/";
            for (int problem = 0; problem < this.experiment.getProblemList().size(); ++problem) {
                String path = algorithmPath + this.experiment.getProblemList().get(problem).getTag() + "/" + indicator.getName();
                this.readDataFromFile(path, data, algorithm);
            }
        }
        return data;
    }

    private void readDataFromFile(String path, Vector<Vector<Double>> data, int algorithmIndex) {
        Object string = "";
        try (FileInputStream fis = new FileInputStream(path);){
            byte[] bytes = new byte[4096];
            int readBytes = 0;
            while (readBytes != -1) {
                readBytes = fis.read(bytes);
                if (readBytes == -1) continue;
                string = (String)string + new String(bytes, 0, readBytes);
            }
        }
        catch (IOException e) {
            throw new JMetalException("Error reading data ", (Exception)e);
        }
        StringTokenizer lines = new StringTokenizer((String)string, "\n\r");
        double valor = 0.0;
        int n = 0;
        while (lines.hasMoreTokens()) {
            valor += Double.parseDouble(lines.nextToken());
            ++n;
        }
        if (n != 0) {
            data.elementAt(algorithmIndex).add(valor / (double)n);
        } else {
            data.elementAt(algorithmIndex).add(valor);
        }
    }

    private double[] computeAverageRanking(Vector<Vector<Double>> data) {
        int i;
        int i2;
        double[][] mean = new double[this.numberOfProblems][this.numberOfAlgorithms];
        for (int j = 0; j < this.numberOfAlgorithms; ++j) {
            for (i2 = 0; i2 < this.numberOfProblems; ++i2) {
                mean[i2][j] = data.elementAt(j).elementAt(i2);
            }
        }
        ArrayList order = new ArrayList(this.numberOfProblems);
        for (i2 = 0; i2 < this.numberOfProblems; ++i2) {
            order.add(new ArrayList(this.numberOfAlgorithms));
            for (int j = 0; j < this.numberOfAlgorithms; ++j) {
                ((List)order.get(i2)).add(new ImmutablePair((Object)j, (Object)mean[i2][j]));
            }
            ((List)order.get(i2)).sort(Comparator.comparingDouble(pair -> Math.abs((Double)pair.getValue())));
        }
        ArrayList rank = new ArrayList(this.numberOfProblems);
        int position = 0;
        for (i = 0; i < this.numberOfProblems; ++i) {
            rank.add(new ArrayList(this.numberOfAlgorithms));
            for (int j = 0; j < this.numberOfAlgorithms; ++j) {
                boolean found = false;
                for (int k = 0; k < this.numberOfAlgorithms && !found; ++k) {
                    if ((Integer)((Pair)((List)order.get(i)).get(k)).getKey() != j) continue;
                    found = true;
                    position = k + 1;
                }
                ((List)rank.get(i)).add(new MutablePair((Object)position, (Object)((Double)((Pair)((List)order.get(i)).get(position - 1)).getValue())));
            }
        }
        for (i = 0; i < this.numberOfProblems; ++i) {
            boolean[] hasBeenVisited = new boolean[this.numberOfAlgorithms];
            Vector<Integer> pendingToVisit = new Vector<Integer>();
            Arrays.fill(hasBeenVisited, false);
            for (int j = 0; j < this.numberOfAlgorithms; ++j) {
                int k;
                pendingToVisit.removeAllElements();
                double sum = (Double)((MutablePair)((List)rank.get(i)).get(j)).getKey();
                hasBeenVisited[j] = true;
                int ig = 1;
                for (k = j + 1; k < this.numberOfAlgorithms; ++k) {
                    if (!((Double)((MutablePair)((List)rank.get(i)).get(j)).getValue()).equals(((MutablePair)((List)rank.get(i)).get(k)).getValue()) || hasBeenVisited[k]) continue;
                    sum += ((Double)((MutablePair)((List)rank.get(i)).get(k)).getKey()).doubleValue();
                    ++ig;
                    pendingToVisit.add(k);
                    hasBeenVisited[k] = true;
                }
                ((MutablePair)((List)rank.get(i)).get(j)).setLeft((Object)(sum /= (double)ig));
                for (k = 0; k < pendingToVisit.size(); ++k) {
                    ((MutablePair)((List)rank.get(i)).get((Integer)pendingToVisit.elementAt(k))).setLeft((Object)sum);
                }
            }
        }
        double[] averageRanking = new double[this.numberOfAlgorithms];
        for (int i3 = 0; i3 < this.numberOfAlgorithms; ++i3) {
            averageRanking[i3] = 0.0;
            for (int j = 0; j < this.numberOfProblems; ++j) {
                int n = i3;
                averageRanking[n] = averageRanking[n] + (Double)((MutablePair)((List)rank.get(j)).get(i3)).getKey() / (double)this.numberOfProblems;
            }
        }
        return averageRanking;
    }

    public String prepareFileOutputContents(double[] averageRanking) {
        String fileContents = this.writeLatexHeader();
        fileContents = this.printTableHeader(fileContents);
        fileContents = this.printTableLines(fileContents, averageRanking);
        fileContents = this.printTableTail(fileContents);
        fileContents = this.printDocumentFooter(fileContents, averageRanking);
        return fileContents;
    }

    private void writeLatexFile(QualityIndicator indicator, String fileContents) {
        String outputFile = this.latexDirectoryName + "/FriedmanTest" + indicator.getName() + ".tex";
        File latexOutput = new File(this.latexDirectoryName);
        if (!latexOutput.exists()) {
            latexOutput.mkdirs();
        }
        try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(outputFile));){
            dataOutputStream.writeBytes(fileContents);
        }
        catch (IOException e) {
            throw new JMetalException("Error writing data ", (Exception)e);
        }
    }

    private String writeLatexHeader() {
        return "\\documentclass{article}\n\\usepackage{graphicx}\n\\title{Results}\n\\author{}\n\\date{\\today}\n\\begin{document}\n\\oddsidemargin 0in \\topmargin 0in\\maketitle\n\\\n\\section{Tables}";
    }

    private String printTableLines(String fileContents, double[] averageRanking) {
        Object output = fileContents;
        for (int i = 0; i < this.experiment.getAlgorithmList().size(); ++i) {
            output = (String)output + "\n" + this.experiment.getAlgorithmList().get(i).getAlgorithmTag() + "&" + averageRanking[i] + "\\\\";
        }
        return output;
    }

    private String printTableTail(String fileContents) {
        return fileContents + "\n\\end{tabular}\n\\end{table}";
    }

    private String printTableHeader(String fileContents) {
        return fileContents + "\n\\begin{table}[!htp]\n\\centering\n\\caption{Average ranking of the algorithms}\n\\begin{tabular}{c|c}\nAlgorithm&Ranking\\\\\n\\hline";
    }

    private String printDocumentFooter(String fileContents, double[] averageRanking) {
        double term1 = 12.0 * (double)this.numberOfProblems / (double)(this.numberOfAlgorithms * (this.numberOfAlgorithms + 1));
        double term2 = (double)(this.numberOfAlgorithms * (this.numberOfAlgorithms + 1) * (this.numberOfAlgorithms + 1)) / 4.0;
        double sum = 0.0;
        for (int i = 0; i < this.numberOfAlgorithms; ++i) {
            sum += averageRanking[i] * averageRanking[i];
        }
        double friedman = (sum - term2) * term1;
        String output = fileContents + "\n\n\nFriedman statistic considering reduction performance (distributed according to chi-square with " + (this.numberOfAlgorithms - 1) + " degrees of freedom: " + friedman + ").\n\n";
        output = output + "\n\\end{document}";
        return output;
    }
}

