/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.component.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.component.ExperimentComponent;
import org.uma.jmetal.util.JMetalLogger;

public class GenerateLatexTablesWithStatistics
implements ExperimentComponent {
    private static final String DEFAULT_LATEX_DIRECTORY = "latex";
    private final Experiment<?, ?> experiment;
    private double[][][] mean;
    private double[][][] median;
    private double[][][] stdDeviation;
    private double[][][] iqr;
    private double[][][] max;
    private double[][][] min;
    private double[][][] numberOfValues;

    public GenerateLatexTablesWithStatistics(Experiment<?, ?> configuration) {
        this.experiment = configuration;
        this.experiment.removeDuplicatedAlgorithms();
    }

    @Override
    public void run() throws IOException {
        List<List<List<List<Double>>>> data = this.readDataFromFiles();
        this.computeDataStatistics(data);
        this.generateLatexScript(data);
    }

    private List<List<List<List<Double>>>> readDataFromFiles() throws IOException {
        ArrayList<List<List<List<Double>>>> data = new ArrayList<List<List<List<Double>>>>(this.experiment.getIndicatorList().size());
        for (int indicator = 0; indicator < this.experiment.getIndicatorList().size(); ++indicator) {
            data.add(indicator, new ArrayList());
            for (int problem = 0; problem < this.experiment.getProblemList().size(); ++problem) {
                ((List)data.get(indicator)).add(problem, new ArrayList());
                for (int algorithm = 0; algorithm < this.experiment.getAlgorithmList().size(); ++algorithm) {
                    ((List)((List)data.get(indicator)).get(problem)).add(algorithm, new ArrayList());
                    Object directory = this.experiment.getExperimentBaseDirectory();
                    directory = (String)directory + "/data/";
                    directory = (String)directory + "/" + this.experiment.getAlgorithmList().get(algorithm).getAlgorithmTag();
                    directory = (String)directory + "/" + this.experiment.getProblemList().get(problem).getTag();
                    directory = (String)directory + "/" + this.experiment.getIndicatorList().get(indicator).getName();
                    FileInputStream fis = new FileInputStream((String)directory);
                    InputStreamReader isr = new InputStreamReader(fis);
                    try (BufferedReader br = new BufferedReader(isr);){
                        String aux = br.readLine();
                        while (aux != null) {
                            ((List)((List)((List)data.get(indicator)).get(problem)).get(algorithm)).add(Double.parseDouble(aux));
                            aux = br.readLine();
                        }
                        continue;
                    }
                }
            }
        }
        return data;
    }

    private void computeDataStatistics(List<List<List<List<Double>>>> data) {
        int indicatorListSize = this.experiment.getIndicatorList().size();
        this.mean = new double[indicatorListSize][][];
        this.median = new double[indicatorListSize][][];
        this.stdDeviation = new double[indicatorListSize][][];
        this.iqr = new double[indicatorListSize][][];
        this.min = new double[indicatorListSize][][];
        this.max = new double[indicatorListSize][][];
        this.numberOfValues = new double[indicatorListSize][][];
        int problemListSize = this.experiment.getProblemList().size();
        for (int indicator = 0; indicator < indicatorListSize; ++indicator) {
            this.mean[indicator] = new double[problemListSize][];
            this.median[indicator] = new double[problemListSize][];
            this.stdDeviation[indicator] = new double[problemListSize][];
            this.iqr[indicator] = new double[problemListSize][];
            this.min[indicator] = new double[problemListSize][];
            this.max[indicator] = new double[problemListSize][];
            this.numberOfValues[indicator] = new double[problemListSize][];
            int algorithmListSize = this.experiment.getAlgorithmList().size();
            for (int problem = 0; problem < problemListSize; ++problem) {
                this.mean[indicator][problem] = new double[algorithmListSize];
                this.median[indicator][problem] = new double[algorithmListSize];
                this.stdDeviation[indicator][problem] = new double[algorithmListSize];
                this.iqr[indicator][problem] = new double[algorithmListSize];
                this.min[indicator][problem] = new double[algorithmListSize];
                this.max[indicator][problem] = new double[algorithmListSize];
                this.numberOfValues[indicator][problem] = new double[algorithmListSize];
                for (int algorithm = 0; algorithm < algorithmListSize; ++algorithm) {
                    Collections.sort(data.get(indicator).get(problem).get(algorithm));
                    Map<String, Double> statValues = this.computeStatistics(data.get(indicator).get(problem).get(algorithm));
                    this.mean[indicator][problem][algorithm] = statValues.get("mean");
                    this.median[indicator][problem][algorithm] = statValues.get("median");
                    this.stdDeviation[indicator][problem][algorithm] = statValues.get("stdDeviation");
                    this.iqr[indicator][problem][algorithm] = statValues.get("iqr");
                    this.min[indicator][problem][algorithm] = statValues.get("min");
                    this.max[indicator][problem][algorithm] = statValues.get("max");
                    this.numberOfValues[indicator][problem][algorithm] = statValues.get("numberOfElements").intValue();
                }
            }
        }
    }

    private void generateLatexScript(List<List<List<List<Double>>>> data) throws IOException {
        String latexDirectoryName = this.experiment.getExperimentBaseDirectory() + "/latex";
        File latexOutput = new File(latexDirectoryName);
        if (!latexOutput.exists()) {
            new File(latexDirectoryName).mkdirs();
            JMetalLogger.logger.info("Creating " + latexDirectoryName + " directory");
        }
        String latexFile = latexDirectoryName + "/" + this.experiment.getExperimentName() + ".tex";
        this.printHeaderLatexCommands(latexFile);
        for (int i = 0; i < this.experiment.getIndicatorList().size(); ++i) {
            this.printData(latexFile, i, this.mean, this.stdDeviation, "Mean and Standard Deviation");
            this.printData(latexFile, i, this.median, this.iqr, "Median and Interquartile Range");
        }
        this.printEndLatexCommands(latexFile);
    }

    private Map<String, Double> computeStatistics(List<Double> values) {
        HashMap<String, Double> results = new HashMap<String, Double>();
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (Double value : values) {
            stats.addValue(value.doubleValue());
        }
        results.put("mean", stats.getMean());
        results.put("median", stats.getPercentile(50.0));
        results.put("stdDeviation", stats.getStandardDeviation());
        results.put("iqr", stats.getPercentile(75.0) - stats.getPercentile(25.0));
        results.put("max", stats.getMax());
        results.put("min", stats.getMean());
        results.put("numberOfElements", Double.valueOf(values.size()));
        return results;
    }

    void printHeaderLatexCommands(String fileName) throws IOException {
        try (FileWriter os = new FileWriter(fileName, false);){
            os.write("\\documentclass{article}\n");
            os.write("\\title{" + this.experiment.getExperimentName() + "}\n");
            os.write("\\usepackage{colortbl}\n");
            os.write("\\usepackage[table*]{xcolor}\n");
            os.write("\\xdefinecolor{gray95}{gray}{0.65}\n");
            os.write("\\xdefinecolor{gray25}{gray}{0.8}\n");
            os.write("\\author{A.J. Nebro}\n");
            os.write("\\begin{document}\n");
            os.write("\\maketitle\n");
            os.write("\\section{Tables}\n");
        }
    }

    void printEndLatexCommands(String fileName) throws IOException {
        try (FileWriter os = new FileWriter(fileName, true);){
            os.write("\\end{document}\n");
        }
    }

    private void printData(String latexFile, int indicatorIndex, double[][][] centralTendency, double[][][] dispersion, String caption) throws IOException {
        try (FileWriter os = new FileWriter(latexFile, true);){
            int i;
            os.write("\n");
            os.write("\\begin{table}\n");
            os.write("\\caption{" + this.experiment.getIndicatorList().get(indicatorIndex).getName() + ". " + caption + "}\n");
            os.write("\\label{table: " + this.experiment.getIndicatorList().get(indicatorIndex).getName() + "}\n");
            os.write("\\centering\n");
            os.write("\\begin{scriptsize}\n");
            os.write("\\begin{tabular}{l");
            os.write(StringUtils.repeat((String)"l", (int)this.experiment.getAlgorithmList().size()));
            os.write("}\n");
            os.write("\\hline");
            for (i = -1; i < this.experiment.getAlgorithmList().size(); ++i) {
                if (i == -1) {
                    os.write(" & ");
                    continue;
                }
                if (i == this.experiment.getAlgorithmList().size() - 1) {
                    os.write(" " + this.experiment.getAlgorithmList().get(i).getAlgorithmTag() + "\\\\\n");
                    continue;
                }
                os.write(this.experiment.getAlgorithmList().get(i).getAlgorithmTag() + " & ");
            }
            os.write("\\hline \n");
            for (i = 0; i < this.experiment.getProblemList().size(); ++i) {
                int j;
                double secondBestDispersionValue;
                double secondBestCentralTendencyValue;
                double bestDispersionValue;
                double bestCentralTendencyValue;
                int bestIndex = -1;
                int secondBestIndex = -1;
                if (this.experiment.getIndicatorList().get(indicatorIndex).isTheLowerTheIndicatorValueTheBetter()) {
                    bestCentralTendencyValue = Double.MAX_VALUE;
                    bestDispersionValue = Double.MAX_VALUE;
                    secondBestCentralTendencyValue = Double.MAX_VALUE;
                    secondBestDispersionValue = Double.MAX_VALUE;
                    for (j = 0; j < this.experiment.getAlgorithmList().size(); ++j) {
                        if (centralTendency[indicatorIndex][i][j] < bestCentralTendencyValue || centralTendency[indicatorIndex][i][j] == bestCentralTendencyValue && dispersion[indicatorIndex][i][j] < bestDispersionValue) {
                            secondBestIndex = bestIndex;
                            secondBestCentralTendencyValue = bestCentralTendencyValue;
                            secondBestDispersionValue = bestDispersionValue;
                            bestCentralTendencyValue = centralTendency[indicatorIndex][i][j];
                            bestDispersionValue = dispersion[indicatorIndex][i][j];
                            bestIndex = j;
                            continue;
                        }
                        if (!(centralTendency[indicatorIndex][i][j] < secondBestCentralTendencyValue) && (centralTendency[indicatorIndex][i][j] != secondBestCentralTendencyValue || !(dispersion[indicatorIndex][i][j] < secondBestDispersionValue))) continue;
                        secondBestIndex = j;
                        secondBestCentralTendencyValue = centralTendency[indicatorIndex][i][j];
                        secondBestDispersionValue = dispersion[indicatorIndex][i][j];
                    }
                } else {
                    bestCentralTendencyValue = Double.MIN_VALUE;
                    bestDispersionValue = Double.MIN_VALUE;
                    secondBestCentralTendencyValue = Double.MIN_VALUE;
                    secondBestDispersionValue = Double.MIN_VALUE;
                    for (j = 0; j < this.experiment.getAlgorithmList().size(); ++j) {
                        if (centralTendency[indicatorIndex][i][j] > bestCentralTendencyValue || centralTendency[indicatorIndex][i][j] == bestCentralTendencyValue && dispersion[indicatorIndex][i][j] < bestDispersionValue) {
                            secondBestIndex = bestIndex;
                            secondBestCentralTendencyValue = bestCentralTendencyValue;
                            secondBestDispersionValue = bestDispersionValue;
                            bestCentralTendencyValue = centralTendency[indicatorIndex][i][j];
                            bestDispersionValue = dispersion[indicatorIndex][i][j];
                            bestIndex = j;
                            continue;
                        }
                        if (!(centralTendency[indicatorIndex][i][j] > secondBestCentralTendencyValue) && (centralTendency[indicatorIndex][i][j] != secondBestCentralTendencyValue || !(dispersion[indicatorIndex][i][j] < secondBestDispersionValue))) continue;
                        secondBestIndex = j;
                        secondBestCentralTendencyValue = centralTendency[indicatorIndex][i][j];
                        secondBestDispersionValue = dispersion[indicatorIndex][i][j];
                    }
                }
                os.write(this.experiment.getProblemList().get(i).getTag().replace("_", "\\_") + " & ");
                for (j = 0; j < this.experiment.getAlgorithmList().size() - 1; ++j) {
                    if (j == bestIndex) {
                        os.write("\\cellcolor{gray95}");
                    }
                    if (j == secondBestIndex) {
                        os.write("\\cellcolor{gray25}");
                    }
                    String m = String.format(Locale.ENGLISH, "%10.2e", centralTendency[indicatorIndex][i][j]);
                    String s = String.format(Locale.ENGLISH, "%8.1e", dispersion[indicatorIndex][i][j]);
                    os.write("$" + m + "_{" + s + "}$ & ");
                }
                if (bestIndex == this.experiment.getAlgorithmList().size() - 1) {
                    os.write("\\cellcolor{gray95}");
                }
                if (secondBestIndex == this.experiment.getAlgorithmList().size() - 1) {
                    os.write("\\cellcolor{gray25}");
                }
                String m = String.format(Locale.ENGLISH, "%10.2e", centralTendency[indicatorIndex][i][this.experiment.getAlgorithmList().size() - 1]);
                String s = String.format(Locale.ENGLISH, "%8.1e", dispersion[indicatorIndex][i][this.experiment.getAlgorithmList().size() - 1]);
                os.write("$" + m + "_{" + s + "}$ \\\\\n");
            }
            os.write("\\hline\n");
            os.write("\\end{tabular}\n");
            os.write("\\end{scriptsize}\n");
            os.write("\\end{table}\n");
        }
    }
}

