/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.component.impl;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.component.ExperimentComponent;
import org.uma.jmetal.lab.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.pointsolution.PointSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.legacy.front.Front;
import org.uma.jmetal.util.legacy.front.impl.ArrayFront;
import org.uma.jmetal.util.legacy.front.util.FrontUtils;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class GenerateReferenceParetoFront
implements ExperimentComponent {
    private final Experiment<?, ?> experiment;

    public GenerateReferenceParetoFront(Experiment<?, ?> experimentConfiguration) {
        this.experiment = experimentConfiguration;
        this.experiment.removeDuplicatedAlgorithms();
    }

    @Override
    public void run() throws IOException {
        String outputDirectoryName = this.experiment.getReferenceFrontDirectory();
        this.createOutputDirectory(outputDirectoryName);
        LinkedList<CallSite> referenceFrontFileNames = new LinkedList<CallSite>();
        for (ExperimentProblem<?> problem : this.experiment.getProblemList()) {
            NonDominatedSolutionListArchive nonDominatedSolutionArchive = new NonDominatedSolutionListArchive();
            for (ExperimentAlgorithm<?, ?> algorithm : this.experiment.getAlgorithmList()) {
                String problemDirectory = this.experiment.getExperimentBaseDirectory() + "/data/" + algorithm.getAlgorithmTag() + "/" + problem.getTag();
                for (int i = 0; i < this.experiment.getIndependentRuns(); ++i) {
                    String frontFileName = problemDirectory + "/" + this.experiment.getOutputParetoFrontFileName() + i + ".csv";
                    ArrayFront front = new ArrayFront(frontFileName, ",");
                    List solutionList = FrontUtils.convertFrontToSolutionList((Front)front);
                    GenericSolutionAttribute solutionAttribute = new GenericSolutionAttribute();
                    for (PointSolution solution : solutionList) {
                        solutionAttribute.setAttribute((Solution)solution, (Object)algorithm.getAlgorithmTag());
                        nonDominatedSolutionArchive.add((Solution)solution);
                    }
                }
            }
            String referenceSetFileName = outputDirectoryName + "/" + problem.getTag() + ".csv";
            referenceFrontFileNames.add((CallSite)((Object)(problem.getTag() + ".csv")));
            new SolutionListOutput(nonDominatedSolutionArchive.solutions()).printObjectivesToFile(referenceSetFileName, ",");
            this.writeFilesWithTheSolutionsContributedByEachAlgorithm(outputDirectoryName, problem, nonDominatedSolutionArchive.solutions());
        }
    }

    private File createOutputDirectory(String outputDirectoryName) {
        File outputDirectory = new File(outputDirectoryName);
        if (!outputDirectory.exists()) {
            boolean result = new File(outputDirectoryName).mkdir();
            JMetalLogger.logger.info("Creating " + outputDirectoryName + ". Status = " + result);
        }
        return outputDirectory;
    }

    private void writeFilesWithTheSolutionsContributedByEachAlgorithm(String outputDirectoryName, ExperimentProblem<?> problem, List<PointSolution> nonDominatedSolutions) throws IOException {
        GenericSolutionAttribute solutionAttribute = new GenericSolutionAttribute();
        for (ExperimentAlgorithm<?, ?> algorithm : this.experiment.getAlgorithmList()) {
            ArrayList<PointSolution> solutionsPerAlgorithm = new ArrayList<PointSolution>();
            for (PointSolution solution : nonDominatedSolutions) {
                if (!algorithm.getAlgorithmTag().equals(solutionAttribute.getAttribute((Solution)solution))) continue;
                solutionsPerAlgorithm.add(solution);
            }
            new SolutionListOutput(solutionsPerAlgorithm).printObjectivesToFile(outputDirectoryName + "/" + problem.getTag() + "." + algorithm.getAlgorithmTag() + ".csv", ",");
        }
    }
}

