/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.component.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.component.ExperimentComponent;
import org.uma.jmetal.lab.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.solution.AbstractSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.solutionattribute.impl.GenericSolutionAttribute;

public class GenerateReferenceParetoSetAndFrontFromDoubleSolutions
implements ExperimentComponent {
    private final Experiment<?, ?> experiment;

    public GenerateReferenceParetoSetAndFrontFromDoubleSolutions(Experiment<?, ?> experimentConfiguration) {
        this.experiment = experimentConfiguration;
    }

    @Override
    public void run() throws IOException {
        String outputDirectoryName = this.experiment.getReferenceFrontDirectory();
        this.createOutputDirectory(outputDirectoryName);
        for (ExperimentProblem<?> problem : this.experiment.getProblemList()) {
            List<DummyDoubleSolution> nonDominatedSolutions = this.getNonDominatedSolutions(problem);
            this.writeReferenceFrontFile(outputDirectoryName, problem, nonDominatedSolutions);
            this.writeReferenceSetFile(outputDirectoryName, problem, nonDominatedSolutions);
            this.writeFilesWithTheSolutionsContributedByEachAlgorithm(outputDirectoryName, problem, nonDominatedSolutions);
        }
    }

    private void writeFilesWithTheSolutionsContributedByEachAlgorithm(String outputDirectoryName, ExperimentProblem<?> problem, List<DummyDoubleSolution> nonDominatedSolutions) {
        GenericSolutionAttribute solutionAttribute = new GenericSolutionAttribute();
        for (ExperimentAlgorithm<?, ?> algorithm : this.experiment.getAlgorithmList()) {
            ArrayList<DoubleSolution> solutionsPerAlgorithm = new ArrayList<DoubleSolution>();
            for (DoubleSolution doubleSolution : nonDominatedSolutions) {
                if (!algorithm.getAlgorithmTag().equals(solutionAttribute.getAttribute((Solution)doubleSolution))) continue;
                solutionsPerAlgorithm.add(doubleSolution);
            }
            new SolutionListOutput(solutionsPerAlgorithm).printObjectivesToFile(outputDirectoryName + "/" + problem.getTag() + "." + algorithm.getAlgorithmTag() + ".rf", ",");
            new SolutionListOutput(solutionsPerAlgorithm).printVariablesToFile(outputDirectoryName + "/" + problem.getTag() + "." + algorithm.getAlgorithmTag() + ".rs", ",");
        }
    }

    private void writeReferenceFrontFile(String outputDirectoryName, ExperimentProblem<?> problem, List<DummyDoubleSolution> nonDominatedSolutions) {
        String referenceFrontFileName = outputDirectoryName + "/" + problem.getReferenceFront();
        new SolutionListOutput(nonDominatedSolutions).printObjectivesToFile(referenceFrontFileName, ",");
    }

    private void writeReferenceSetFile(String outputDirectoryName, ExperimentProblem<?> problem, List<DummyDoubleSolution> nonDominatedSolutions) {
        String referenceSetFileName = outputDirectoryName + "/" + problem.getTag() + ".ps";
        new SolutionListOutput(nonDominatedSolutions).printVariablesToFile(referenceSetFileName, ",");
    }

    private List<DummyDoubleSolution> getNonDominatedSolutions(ExperimentProblem<?> problem) throws IOException {
        NonDominatedSolutionListArchive nonDominatedSolutionArchive = new NonDominatedSolutionListArchive();
        for (ExperimentAlgorithm algorithm : this.experiment.getAlgorithmList().stream().filter(s -> s.getProblemTag().equals(problem.getTag())).collect(Collectors.toCollection(ArrayList::new))) {
            String problemDirectory = this.experiment.getExperimentBaseDirectory() + "/data/" + algorithm.getAlgorithmTag() + "/" + problem.getTag();
            String frontFileName = problemDirectory + "/" + this.experiment.getOutputParetoFrontFileName() + algorithm.getRunId() + ".csv";
            String paretoSetFileName = problemDirectory + "/" + this.experiment.getOutputParetoSetFileName() + algorithm.getRunId() + ".csv";
            double[][] frontWithObjectiveValues = VectorUtils.readVectors((String)frontFileName, (String)",");
            double[][] frontWithVariableValues = VectorUtils.readVectors((String)paretoSetFileName, (String)",");
            List<DummyDoubleSolution> solutionList = this.createSolutionListFrontFiles(algorithm.getAlgorithmTag(), frontWithVariableValues, frontWithObjectiveValues);
            for (DummyDoubleSolution solution : solutionList) {
                nonDominatedSolutionArchive.add((Solution)solution);
            }
        }
        return nonDominatedSolutionArchive.solutions();
    }

    private File createOutputDirectory(String outputDirectoryName) {
        File outputDirectory = new File(outputDirectoryName);
        if (!outputDirectory.exists()) {
            boolean result = new File(outputDirectoryName).mkdir();
            JMetalLogger.logger.info("Creating " + outputDirectoryName + ". Status = " + result);
        }
        return outputDirectory;
    }

    private List<DummyDoubleSolution> createSolutionListFrontFiles(String algorithmName, double[][] frontWithVariableValues, double[][] frontWithObjectiveValues) {
        if (frontWithVariableValues.length != frontWithObjectiveValues.length) {
            throw new JMetalException("The number of solutions in the variable and objective fronts are not equal");
        }
        if (frontWithObjectiveValues.length == 0) {
            throw new JMetalException("The front of solutions is empty");
        }
        GenericSolutionAttribute solutionAttribute = new GenericSolutionAttribute();
        int numberOfVariables = frontWithVariableValues[0].length;
        int numberOfObjectives = frontWithObjectiveValues[0].length;
        ArrayList<DummyDoubleSolution> solutionList = new ArrayList<DummyDoubleSolution>();
        for (int i = 0; i < frontWithVariableValues.length; ++i) {
            DummyDoubleSolution solution = new DummyDoubleSolution(numberOfVariables, numberOfObjectives);
            for (int vars = 0; vars < numberOfVariables; ++vars) {
                solution.variables().set(vars, frontWithVariableValues[i][vars]);
            }
            for (int objs = 0; objs < numberOfObjectives; ++objs) {
                solution.objectives()[objs] = frontWithObjectiveValues[i][objs];
            }
            solutionAttribute.setAttribute((Solution)solution, (Object)algorithmName);
            solutionList.add(solution);
        }
        return solutionList;
    }

    private static class DummyDoubleSolution
    extends AbstractSolution<Double>
    implements DoubleSolution {
        public DummyDoubleSolution(int numberOfVariables, int numberOfObjectives) {
            super(numberOfVariables, numberOfObjectives);
        }

        public Solution<Double> copy() {
            return null;
        }

        public Bounds<Double> getBounds(int index) {
            return null;
        }
    }
}

