/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.component.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.component.ExperimentComponent;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;

public class GenerateWilcoxonTestTablesWithR<Result extends List<? extends Solution<?>>>
implements ExperimentComponent {
    private static final String DEFAULT_R_DIRECTORY = "R";
    private static final String APPEND_STRING = "\", append=TRUE)\n";
    private static final String END_JUMP_STRING = "}\n";
    private final Experiment<?, Result> experiment;

    public GenerateWilcoxonTestTablesWithR(Experiment<?, Result> experimentConfiguration) {
        this.experiment = experimentConfiguration;
        this.experiment.removeDuplicatedAlgorithms();
    }

    @Override
    public void run() throws IOException {
        String rDirectoryName = this.experiment.getExperimentBaseDirectory() + "/R";
        File rOutput = new File(rDirectoryName);
        if (!rOutput.exists()) {
            new File(rDirectoryName).mkdirs();
            JMetalLogger.logger.info("GenerateWilcoxonTestTablesWithR. Creating " + rDirectoryName + " directory");
        }
        for (QualityIndicator indicator : this.experiment.getIndicatorList()) {
            String rFileName = rDirectoryName + "/" + indicator.getName() + ".Wilcoxon.R";
            String latexFileName = indicator.getName() + ".Wilcoxon.tex";
            this.printHeaderLatexCommands(rFileName, latexFileName);
            this.printTableHeader(indicator, rFileName, latexFileName);
            this.printLines(indicator, rFileName, latexFileName);
            this.printTableTail(rFileName, latexFileName);
            this.printEndLatexCommands(rFileName, latexFileName);
            this.printGenerateMainScript(indicator, rFileName, latexFileName);
        }
    }

    private void printHeaderLatexCommands(String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, false);){
            String output = "write(\"\", \"" + latexFileName + "\",append=FALSE)";
            os.write(output + "\n");
            String dataDirectory = "../data";
            os.write("resultDirectory<-\"" + dataDirectory + "\"\n");
            output = "latexHeader <- function() {\n  write(\"\\\\documentclass{article}\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\title{StandardStudy}\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\usepackage{amssymb}\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\author{A.J.Nebro}\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\begin{document}\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\maketitle\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\section{Tables}\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\\", \"" + latexFileName + "\", append=TRUE)\n}\n";
            os.write(output + "\n");
        }
    }

    private void printEndLatexCommands(String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, true);){
            String output = "latexTail <- function() { \n  write(\"\\\\end{document}\", \"" + latexFileName + "\", append=TRUE)\n}\n";
            os.write(output + "\n");
        }
    }

    private void printTableHeader(QualityIndicator indicator, String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, true);){
            Object latexTableLabel = "";
            Object latexTableCaption = "";
            latexTableCaption = "  write(\"\\\\caption{\", \"" + latexFileName + "\", append=TRUE)\n  write(problem, \"" + latexFileName + "\", append=TRUE)\n  write(\"." + indicator.getName() + ".}\", \"" + latexFileName + APPEND_STRING;
            latexTableLabel = "  write(\"\\\\label{Table:\", \"" + latexFileName + "\", append=TRUE)\n  write(problem, \"" + latexFileName + "\", append=TRUE)\n  write(\"." + indicator.getName() + ".}\", \"" + latexFileName + APPEND_STRING;
            String output = "latexTableHeader <- function(problem, tabularString, latexTableFirstLine) {\n  write(\"\\\\begin{table}\", \"" + latexFileName + APPEND_STRING + (String)latexTableCaption + "\n" + (String)latexTableLabel + "\n  write(\"\\\\centering\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\setlength\\\\tabcolsep{1pt}\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\begin{scriptsize}\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\begin{tabular}{\", \"" + latexFileName + "\", append=TRUE)\n  write(tabularString, \"" + latexFileName + "\", append=TRUE)\n  write(\"}\", \"" + latexFileName + "\", append=TRUE)\n  write(latexTableFirstLine, \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\hline \", \"" + latexFileName + "\", append=TRUE)\n}\n";
            os.write(output + "\n");
        }
    }

    private void printTableTail(String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, true);){
            String output = "latexTableTail <- function() { \n  write(\"\\\\hline\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\end{tabular}\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\end{scriptsize}\", \"" + latexFileName + "\", append=TRUE)\n  write(\"\\\\end{table}\", \"" + latexFileName + "\", append=TRUE)\n}\n";
            os.write(output + "\n");
        }
    }

    private void printLines(QualityIndicator indicator, String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, true);){
            String output = indicator.isTheLowerTheIndicatorValueTheBetter() ? "printTableLine <- function(indicator, algorithm1, algorithm2, i, j, problem) { \n  file1<-paste(resultDirectory, algorithm1, sep=\"/\")\n  file1<-paste(file1, problem, sep=\"/\")\n  file1<-paste(file1, indicator, sep=\"/\")\n  data1<-scan(file1)\n  file2<-paste(resultDirectory, algorithm2, sep=\"/\")\n  file2<-paste(file2, problem, sep=\"/\")\n  file2<-paste(file2, indicator, sep=\"/\")\n  data2<-scan(file2)\n  if (i == j) {\n    write(\"-- \", \"" + latexFileName + "\", append=TRUE)\n  }\n  else if (i < j) {\n    if (is.finite(wilcox.test(data1, data2)$p.value) & wilcox.test(data1, data2)$p.value <= 0.05) {\n      if (median(data1) <= median(data2)) {\n        write(\"$\\\\blacktriangle$\", \"" + latexFileName + "\", append=TRUE)\n}\n      else {\n        write(\"$\\\\triangledown$\", \"" + latexFileName + "\", append=TRUE)\n}\n    }\n    else {\n      write(\"--\", \"" + latexFileName + "\", append=TRUE)\n    }\n  }\n  else {\n    write(\" \", \"" + latexFileName + "\", append=TRUE)\n  }\n}\n" : "printTableLine <- function(indicator, algorithm1, algorithm2, i, j, problem) { \n  file1<-paste(resultDirectory, algorithm1, sep=\"/\")\n  file1<-paste(file1, problem, sep=\"/\")\n  file1<-paste(file1, indicator, sep=\"/\")\n  data1<-scan(file1)\n  file2<-paste(resultDirectory, algorithm2, sep=\"/\")\n  file2<-paste(file2, problem, sep=\"/\")\n  file2<-paste(file2, indicator, sep=\"/\")\n  data2<-scan(file2)\n  if (i == j) {\n    write(\"--\", \"" + latexFileName + "\", append=TRUE)\n  }\n  else if (i < j) {\n    if (is.finite(wilcox.test(data1, data2)$p.value) & wilcox.test(data1, data2)$p.value <= 0.05) {\n      if (median(data1) >= median(data2)) {\n        write(\"$\\\\blacktriangle$\", \"" + latexFileName + "\", append=TRUE)\n}\n      else {\n        write(\"$\\\\triangledown$\", \"" + latexFileName + "\", append=TRUE)\n}\n}\n    else {\n      write(\"$-$\", \"" + latexFileName + "\", append=TRUE)\n}\n  }\n  else {\n    write(\" \", \"" + latexFileName + "\", append=TRUE)\n  }\n}\n";
            os.write(output + "\n");
        }
    }

    private void printGenerateMainScript(QualityIndicator indicator, String rFileName, String latexFileName) throws IOException {
        try (FileWriter os = new FileWriter(rFileName, true);){
            int i;
            Object output = "### START OF SCRIPT ";
            os.write((String)output + "\n");
            Object problemList = "problemList <-c(";
            Object algorithmList = "algorithmList <-c(";
            for (i = 0; i < this.experiment.getProblemList().size() - 1; ++i) {
                problemList = (String)problemList + "\"" + this.experiment.getProblemList().get(i).getTag() + "\", ";
            }
            problemList = (String)problemList + "\"" + this.experiment.getProblemList().get(this.experiment.getProblemList().size() - 1).getTag() + "\") ";
            for (i = 0; i < this.experiment.getAlgorithmList().size() - 1; ++i) {
                algorithmList = (String)algorithmList + "\"" + this.experiment.getAlgorithmList().get(i).getAlgorithmTag() + "\", ";
            }
            algorithmList = (String)algorithmList + "\"" + this.experiment.getAlgorithmList().get(this.experiment.getAlgorithmList().size() - 1).getAlgorithmTag() + "\") ";
            Object latexTabularAlignment = "l";
            for (int i2 = 1; i2 < this.experiment.getAlgorithmList().size(); ++i2) {
                latexTabularAlignment = (String)latexTabularAlignment + "c";
            }
            latexTabularAlignment = "l";
            Object latexTableFirstLine = "\\\\hline ";
            for (int i3 = 1; i3 < this.experiment.getAlgorithmList().size(); ++i3) {
                latexTabularAlignment = (String)latexTabularAlignment + "c";
                latexTableFirstLine = (String)latexTableFirstLine + " & " + this.experiment.getAlgorithmList().get(i3).getAlgorithmTag();
            }
            latexTableFirstLine = (String)latexTableFirstLine + "\\\\\\\\ \"";
            String tabularString = "tabularString <-c(\"" + (String)latexTabularAlignment + "\") ";
            String tableFirstLine = "latexTableFirstLine <-c(\"" + (String)latexTableFirstLine + ") ";
            output = "# Constants\n" + (String)problemList + "\n" + (String)algorithmList + "\n" + tabularString + "\n" + tableFirstLine + "\nindicator<-\"" + indicator.getName() + "\"";
            os.write((String)output + "\n");
            output = "\n # Step 1.  Writes the latex header\nlatexHeader()";
            os.write((String)output + "\n");
            problemList = "";
            for (ExperimentProblem<?> problem : this.experiment.getProblemList()) {
                problemList = (String)problemList + problem.getTag() + " ";
            }
            latexTabularAlignment = "| l | ";
            latexTableFirstLine = "\\\\hline \\\\multicolumn{1}{|c|}{}";
            for (int i4 = 1; i4 < this.experiment.getAlgorithmList().size(); ++i4) {
                latexTabularAlignment = (String)latexTabularAlignment + StringUtils.repeat((String)"c", (int)this.experiment.getProblemList().size());
                latexTableFirstLine = (String)latexTableFirstLine + " & \\\\multicolumn{" + this.experiment.getProblemList().size() + "}{c|}{" + this.experiment.getAlgorithmList().get(i4).getAlgorithmTag() + "}";
                latexTabularAlignment = (String)latexTabularAlignment + " | ";
            }
            latexTableFirstLine = (String)latexTableFirstLine + " \\\\\\\\";
            tabularString = "tabularString <-c(\"" + (String)latexTabularAlignment + "\") ";
            latexTableFirstLine = "latexTableFirstLine <-c(\"" + (String)latexTableFirstLine + "\") ";
            output = tabularString;
            os.write((String)output + "\n\n");
            output = latexTableFirstLine;
            os.write((String)output + "\n\n");
            output = "# Step 3. Problem loop \nlatexTableHeader(\"" + (String)problemList + "\", tabularString, latexTableFirstLine)\n\nindx = 0\nfor (i in algorithmList) {\n  if (i != \"" + this.experiment.getAlgorithmList().get(this.experiment.getAlgorithmList().size() - 1).getAlgorithmTag() + "\") {\n    write(i , \"" + latexFileName + "\", append=TRUE)\n    write(\" & \", \"" + latexFileName + "\", append=TRUE)\n\n    jndx = 0\n    for (j in algorithmList) {\n      for (problem in problemList) {\n        if (jndx != 0) {\n          if (i != j) {\n            printTableLine(indicator, i, j, indx, jndx, problem)\n          }\n          else {\n            write(\"  \", \"" + latexFileName + "\", append=TRUE)\n          } \n          if (problem == \"" + this.experiment.getProblemList().get(this.experiment.getProblemList().size() - 1).getTag() + "\") {\n            if (j == \"" + this.experiment.getAlgorithmList().get(this.experiment.getAlgorithmList().size() - 1).getAlgorithmTag() + "\") {\n              write(\" \\\\\\\\ \", \"" + latexFileName + "\", append=TRUE)\n            } \n            else {\n              write(\" & \", \"" + latexFileName + "\", append=TRUE)\n            }\n          }\n     else {\n    write(\"&\", \"" + latexFileName + "\", append=TRUE)\n     }\n        }\n      }\n      jndx = jndx + 1\n}\n    indx = indx + 1\n  }\n} # for algorithm\n\n  latexTableTail()\n";
            os.write((String)output + "\n");
            output = "#Step 3. Writes the end of latex file \nlatexTail()\n";
            os.write((String)output + "\n");
        }
    }
}

