/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.studies;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.mocell.MOCellBuilder;
import org.uma.jmetal.algorithm.multiobjective.mochc.MOCHC;
import org.uma.jmetal.algorithm.multiobjective.mochc.MOCHCBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2Builder;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.ExperimentBuilder;
import org.uma.jmetal.lab.experiment.component.impl.ComputeQualityIndicators;
import org.uma.jmetal.lab.experiment.component.impl.ExecuteAlgorithms;
import org.uma.jmetal.lab.experiment.component.impl.GenerateBoxplotsWithR;
import org.uma.jmetal.lab.experiment.component.impl.GenerateFriedmanTestTables;
import org.uma.jmetal.lab.experiment.component.impl.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.lab.experiment.component.impl.GenerateReferenceParetoFront;
import org.uma.jmetal.lab.experiment.component.impl.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.lab.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.HUXCrossover;
import org.uma.jmetal.operator.crossover.impl.SinglePointCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.BitFlipMutation;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.RandomSelection;
import org.uma.jmetal.operator.selection.impl.RankingAndCrowdingSelection;
import org.uma.jmetal.problem.binaryproblem.BinaryProblem;
import org.uma.jmetal.problem.multiobjective.OneZeroMax;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT5;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.NormalizedHypervolume;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.impl.PISAHypervolume;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class BinaryProblemsStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Needed arguments: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        ArrayList problemList = new ArrayList();
        problemList.add(new ExperimentProblem(new ZDT5()));
        problemList.add(new ExperimentProblem(new OneZeroMax(Integer.valueOf(512))));
        List algorithmList = BinaryProblemsStudy.configureAlgorithmList(problemList);
        Experiment experiment = new ExperimentBuilder("BinaryProblemsStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setReferenceFrontDirectory(experimentBaseDirectory + "/BinaryProblemsStudy/referenceFronts").setIndicatorList(Arrays.asList(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new NormalizedHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus())).setIndependentRuns(25).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new GenerateReferenceParetoFront(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(1).setColumns(2).setDisplayNotch().run();
    }

    static List<ExperimentAlgorithm<BinarySolution, List<BinarySolution>>> configureAlgorithmList(List<ExperimentProblem<BinarySolution>> problemList) {
        ArrayList<ExperimentAlgorithm<BinarySolution, List<BinarySolution>>> algorithms = new ArrayList<ExperimentAlgorithm<BinarySolution, List<BinarySolution>>>();
        for (int run = 0; run < 25; ++run) {
            NSGAII algorithm;
            for (ExperimentProblem<BinarySolution> problem : problemList) {
                algorithm = new NSGAIIBuilder(problem.getProblem(), (CrossoverOperator)new SinglePointCrossover(1.0), (MutationOperator)new BitFlipMutation(1.0 / (double)((BinaryProblem)problem.getProblem()).bitsFromVariable(0)), 100).setMaxEvaluations(25000).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, problem, run));
            }
            for (ExperimentProblem<BinarySolution> problem : problemList) {
                algorithm = new SPEA2Builder(problem.getProblem(), (CrossoverOperator)new SinglePointCrossover(1.0), (MutationOperator)new BitFlipMutation(1.0 / (double)((BinaryProblem)problem.getProblem()).bitsFromVariable(0))).setMaxIterations(250).setPopulationSize(100).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, problem, run));
            }
            for (ExperimentProblem<BinarySolution> problem : problemList) {
                algorithm = new MOCellBuilder(problem.getProblem(), (CrossoverOperator)new SinglePointCrossover(1.0), (MutationOperator)new BitFlipMutation(1.0 / (double)((BinaryProblem)problem.getProblem()).bitsFromVariable(0))).setMaxEvaluations(25000).setPopulationSize(100).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, problem, run));
            }
            for (ExperimentProblem<BinarySolution> problem : problemList) {
                HUXCrossover crossoverOperator = new HUXCrossover(1.0);
                RandomSelection parentsSelection = new RandomSelection();
                RankingAndCrowdingSelection newGenerationSelection = new RankingAndCrowdingSelection(100);
                BitFlipMutation mutationOperator = new BitFlipMutation(0.35);
                MOCHC algorithm2 = new MOCHCBuilder((BinaryProblem)problem.getProblem()).setInitialConvergenceCount(0.25).setConvergenceValue(3).setPreservedPopulation(0.05).setPopulationSize(100).setMaxEvaluations(25000).setCrossover((CrossoverOperator)crossoverOperator).setNewGenerationSelection((SelectionOperator)newGenerationSelection).setCataclysmicMutation((MutationOperator)mutationOperator).setParentSelection((SelectionOperator)parentsSelection).setEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
                algorithms.add(new ExperimentAlgorithm(algorithm2, problem, run));
            }
        }
        return algorithms;
    }
}

