/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.studies;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSO;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOBuilder;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2Builder;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.ExperimentBuilder;
import org.uma.jmetal.lab.experiment.component.impl.ComputeQualityIndicators;
import org.uma.jmetal.lab.experiment.component.impl.ExecuteAlgorithms;
import org.uma.jmetal.lab.experiment.component.impl.GenerateBoxplotsWithR;
import org.uma.jmetal.lab.experiment.component.impl.GenerateFriedmanTestTables;
import org.uma.jmetal.lab.experiment.component.impl.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.lab.experiment.component.impl.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.lab.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ1;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ2;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ3;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ4;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ5;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ6;
import org.uma.jmetal.problem.multiobjective.dtlz.DTLZ7;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GeneralizedSpread;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.NormalizedHypervolume;
import org.uma.jmetal.qualityindicator.impl.hypervolume.impl.PISAHypervolume;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class DTLZStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Missing argument: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        ArrayList problemList = new ArrayList();
        problemList.add(new ExperimentProblem(new DTLZ1()).setReferenceFront("DTLZ1.3D.csv"));
        problemList.add(new ExperimentProblem(new DTLZ2()).setReferenceFront("DTLZ1.3D.csv"));
        problemList.add(new ExperimentProblem(new DTLZ3()).setReferenceFront("DTLZ1.3D.csv"));
        problemList.add(new ExperimentProblem(new DTLZ4()).setReferenceFront("DTLZ1.3D.csv"));
        problemList.add(new ExperimentProblem(new DTLZ5()).setReferenceFront("DTLZ1.3D.csv"));
        problemList.add(new ExperimentProblem(new DTLZ6()).setReferenceFront("DTLZ1.3D.csv"));
        problemList.add(new ExperimentProblem(new DTLZ7()).setReferenceFront("DTLZ1.3D.csv"));
        List algorithmList = DTLZStudy.configureAlgorithmList(problemList);
        Experiment experiment = new ExperimentBuilder("DTLZStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setReferenceFrontDirectory("resources/referenceFrontsCSV").setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setIndicatorList(Arrays.asList(new Epsilon(), new GeneralizedSpread(), new GenerationalDistance(), new PISAHypervolume(), new NormalizedHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus())).setIndependentRuns(25).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(3).setColumns(3).setDisplayNotch().run();
    }

    static List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> configureAlgorithmList(List<ExperimentProblem<DoubleSolution>> problemList) {
        ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms = new ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>>();
        for (int run = 0; run < 25; ++run) {
            int i;
            for (i = 0; i < problemList.size(); ++i) {
                double mutationProbability = 1.0 / (double)problemList.get(i).getProblem().numberOfVariables();
                double mutationDistributionIndex = 20.0;
                SMPSO algorithm = new SMPSOBuilder((DoubleProblem)problemList.get(i).getProblem(), (BoundedArchive)new CrowdingDistanceArchive(100)).setMutation((MutationOperator)new PolynomialMutation(mutationProbability, mutationDistributionIndex)).setMaxIterations(250).setSwarmSize(100).setSolutionListEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                NSGAII algorithm = new NSGAIIBuilder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 20.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().numberOfVariables(), 20.0), 100).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                SPEA2 algorithm = new SPEA2Builder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 10.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().numberOfVariables(), 20.0)).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, problemList.get(i), run));
            }
        }
        return algorithms;
    }
}

