/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.studies;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.ExperimentBuilder;
import org.uma.jmetal.lab.experiment.component.impl.ComputeQualityIndicators;
import org.uma.jmetal.lab.experiment.component.impl.ExecuteAlgorithms;
import org.uma.jmetal.lab.experiment.component.impl.GenerateBoxplotsWithR;
import org.uma.jmetal.lab.experiment.component.impl.GenerateFriedmanHolmTestTables;
import org.uma.jmetal.lab.experiment.component.impl.GenerateHtmlPages;
import org.uma.jmetal.lab.experiment.component.impl.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.lab.experiment.component.impl.GenerateReferenceParetoSetAndFrontFromDoubleSolutions;
import org.uma.jmetal.lab.experiment.component.impl.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.lab.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT2;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT3;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT4;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT6;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.NormalizedHypervolume;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.impl.PISAHypervolume;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class NSGAIIComputingReferenceParetoFrontsStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Needed arguments: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        ArrayList problemList = new ArrayList();
        problemList.add(new ExperimentProblem(new ZDT1()));
        problemList.add(new ExperimentProblem(new ZDT2()));
        problemList.add(new ExperimentProblem(new ZDT3()));
        problemList.add(new ExperimentProblem(new ZDT4()));
        problemList.add(new ExperimentProblem(new ZDT6()));
        List algorithmList = NSGAIIComputingReferenceParetoFrontsStudy.configureAlgorithmList(problemList);
        Experiment experiment = new ExperimentBuilder("NSGAIIComputingReferenceParetoFrontsStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setReferenceFrontDirectory(experimentBaseDirectory + "/NSGAIIComputingReferenceParetoFrontsStudy/referenceFronts").setIndicatorList(Arrays.asList(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new NormalizedHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus())).setIndependentRuns(25).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new GenerateReferenceParetoSetAndFrontFromDoubleSolutions(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateFriedmanHolmTestTables(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(3).setColumns(2).run();
        new GenerateHtmlPages(experiment).run();
    }

    static List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> configureAlgorithmList(List<ExperimentProblem<DoubleSolution>> problemList) {
        ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms = new ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>>();
        for (int run = 0; run < 25; ++run) {
            NSGAII algorithm;
            for (ExperimentProblem<DoubleSolution> experimentProblem : problemList) {
                algorithm = new NSGAIIBuilder(experimentProblem.getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 5.0), (MutationOperator)new PolynomialMutation(1.0 / (double)experimentProblem.getProblem().numberOfVariables(), 10.0), 100).setMaxEvaluations(25000).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, "NSGAIIa", experimentProblem, run));
            }
            for (ExperimentProblem<DoubleSolution> experimentProblem : problemList) {
                algorithm = new NSGAIIBuilder(experimentProblem.getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 20.0), (MutationOperator)new PolynomialMutation(1.0 / (double)experimentProblem.getProblem().numberOfVariables(), 20.0), 100).setMaxEvaluations(25000).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, "NSGAIIb", experimentProblem, run));
            }
            for (ExperimentProblem<DoubleSolution> experimentProblem : problemList) {
                algorithm = new NSGAIIBuilder(experimentProblem.getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 40.0), (MutationOperator)new PolynomialMutation(1.0 / (double)experimentProblem.getProblem().numberOfVariables(), 40.0), 100).setMaxEvaluations(25000).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, "NSGAIIc", experimentProblem, run));
            }
            for (ExperimentProblem<DoubleSolution> experimentProblem : problemList) {
                algorithm = new NSGAIIBuilder(experimentProblem.getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 80.0), (MutationOperator)new PolynomialMutation(1.0 / (double)experimentProblem.getProblem().numberOfVariables(), 80.0), 100).setMaxEvaluations(25000).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, "NSGAIId", experimentProblem, run));
            }
        }
        return algorithms;
    }
}

