/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.studies;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.ExperimentBuilder;
import org.uma.jmetal.lab.experiment.component.impl.ComputeQualityIndicators;
import org.uma.jmetal.lab.experiment.component.impl.ExecuteAlgorithms;
import org.uma.jmetal.lab.experiment.component.impl.GenerateBoxplotsWithR;
import org.uma.jmetal.lab.experiment.component.impl.GenerateFriedmanTestTables;
import org.uma.jmetal.lab.experiment.component.impl.GenerateHtmlPages;
import org.uma.jmetal.lab.experiment.component.impl.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.lab.experiment.component.impl.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.lab.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT2;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT3;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT4;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT6;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.NormalizedHypervolume;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.impl.PISAHypervolume;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class NSGAIIStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Missing argument: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        ArrayList problemList = new ArrayList();
        problemList.add(new ExperimentProblem(new ZDT1()));
        problemList.add(new ExperimentProblem(new ZDT2()));
        problemList.add(new ExperimentProblem(new ZDT3()));
        problemList.add(new ExperimentProblem(new ZDT4()));
        problemList.add(new ExperimentProblem(new ZDT6()));
        List algorithmList = NSGAIIStudy.configureAlgorithmList(problemList);
        Experiment experiment = new ExperimentBuilder("NSGAIIStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setReferenceFrontDirectory("resources/referenceFrontsCSV").setIndicatorList(List.of(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new NormalizedHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus())).setIndependentRuns(25).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(2).setColumns(3).run();
        new GenerateHtmlPages(experiment).run();
    }

    static List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> configureAlgorithmList(List<ExperimentProblem<DoubleSolution>> problemList) {
        ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms = new ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>>();
        for (int run = 0; run < 25; ++run) {
            for (ExperimentProblem<DoubleSolution> experimentProblem : problemList) {
                NSGAIIStudy.nsgaIIa(algorithms, run, experimentProblem);
                NSGAIIStudy.nsgaIIb(algorithms, run, experimentProblem);
                NSGAIIStudy.nsgaIIc(algorithms, run, experimentProblem);
                NSGAIIStudy.nsgaIId(algorithms, run, experimentProblem);
            }
        }
        return algorithms;
    }

    private static void nsgaIId(List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms, int run, ExperimentProblem<DoubleSolution> experimentProblem) {
        NSGAII algorithm = new NSGAIIBuilder(experimentProblem.getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 80.0), (MutationOperator)new PolynomialMutation(1.0 / (double)experimentProblem.getProblem().numberOfVariables(), 80.0), 100).setMaxEvaluations(25000).build();
        algorithms.add(new ExperimentAlgorithm(algorithm, "NSGAIId", experimentProblem, run));
    }

    private static void nsgaIIc(List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms, int run, ExperimentProblem<DoubleSolution> experimentProblem) {
        NSGAII algorithm = new NSGAIIBuilder(experimentProblem.getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 40.0), (MutationOperator)new PolynomialMutation(1.0 / (double)experimentProblem.getProblem().numberOfVariables(), 40.0), 10).setMaxEvaluations(25000).build();
        algorithms.add(new ExperimentAlgorithm(algorithm, "NSGAIIc", experimentProblem, run));
    }

    private static void nsgaIIb(List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms, int run, ExperimentProblem<DoubleSolution> experimentProblem) {
        NSGAII algorithm = new NSGAIIBuilder(experimentProblem.getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 20.0), (MutationOperator)new PolynomialMutation(1.0 / (double)experimentProblem.getProblem().numberOfVariables(), 20.0), 100).setMaxEvaluations(25000).build();
        algorithms.add(new ExperimentAlgorithm(algorithm, "NSGAIIb", experimentProblem, run));
    }

    private static void nsgaIIa(List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms, int run, ExperimentProblem<DoubleSolution> experimentProblem) {
        NSGAII algorithm = new NSGAIIBuilder(experimentProblem.getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 5.0), (MutationOperator)new PolynomialMutation(1.0 / (double)experimentProblem.getProblem().numberOfVariables(), 10.0), 100).setMaxEvaluations(25000).build();
        algorithms.add(new ExperimentAlgorithm(algorithm, "NSGAIIa", experimentProblem, run));
    }
}

