/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.studies;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSO;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOBuilder;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2;
import org.uma.jmetal.algorithm.multiobjective.spea2.SPEA2Builder;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.ExperimentBuilder;
import org.uma.jmetal.lab.experiment.component.impl.ComputeQualityIndicators;
import org.uma.jmetal.lab.experiment.component.impl.ExecuteAlgorithms;
import org.uma.jmetal.lab.experiment.component.impl.GenerateBoxplotsWithR;
import org.uma.jmetal.lab.experiment.component.impl.GenerateFriedmanTestTables;
import org.uma.jmetal.lab.experiment.component.impl.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.lab.experiment.component.impl.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.lab.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.problem.multiobjective.wfg.WFG1;
import org.uma.jmetal.problem.multiobjective.wfg.WFG2;
import org.uma.jmetal.problem.multiobjective.wfg.WFG3;
import org.uma.jmetal.problem.multiobjective.wfg.WFG4;
import org.uma.jmetal.problem.multiobjective.wfg.WFG5;
import org.uma.jmetal.problem.multiobjective.wfg.WFG6;
import org.uma.jmetal.problem.multiobjective.wfg.WFG7;
import org.uma.jmetal.problem.multiobjective.wfg.WFG8;
import org.uma.jmetal.problem.multiobjective.wfg.WFG9;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.NormalizedHypervolume;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.impl.PISAHypervolume;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class WFGStudy {
    private static final int INDEPENDENT_RUNS = 15;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Missing argument: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        ArrayList problemList = new ArrayList();
        problemList.add(new ExperimentProblem(new WFG1()).setReferenceFront("WFG1.2D.csv"));
        problemList.add(new ExperimentProblem(new WFG2()).setReferenceFront("WFG2.2D.csv"));
        problemList.add(new ExperimentProblem(new WFG3()).setReferenceFront("WFG3.2D.csv"));
        problemList.add(new ExperimentProblem(new WFG4()).setReferenceFront("WFG4.2D.csv"));
        problemList.add(new ExperimentProblem(new WFG5()).setReferenceFront("WFG5.2D.csv"));
        problemList.add(new ExperimentProblem(new WFG6()).setReferenceFront("WFG6.2D.csv"));
        problemList.add(new ExperimentProblem(new WFG7()).setReferenceFront("WFG7.2D.csv"));
        problemList.add(new ExperimentProblem(new WFG8()).setReferenceFront("WFG8.2D.csv"));
        problemList.add(new ExperimentProblem(new WFG9()).setReferenceFront("WFG9.2D.csv"));
        List algorithmList = WFGStudy.configureAlgorithmList(problemList);
        Experiment experiment = new ExperimentBuilder("WFGStudy").setAlgorithmList(algorithmList).setProblemList(problemList).setReferenceFrontDirectory("resources/referenceFrontsCSV").setExperimentBaseDirectory(experimentBaseDirectory).setOutputParetoFrontFileName("FUN").setOutputParetoSetFileName("VAR").setIndicatorList(Arrays.asList(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new NormalizedHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus())).setIndependentRuns(15).setNumberOfCores(8).build();
        new ExecuteAlgorithms(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(3).setColumns(3).setDisplayNotch().run();
    }

    static List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> configureAlgorithmList(List<ExperimentProblem<DoubleSolution>> problemList) {
        ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms = new ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>>();
        for (int run = 0; run < 15; ++run) {
            int i;
            for (i = 0; i < problemList.size(); ++i) {
                double mutationProbability = 1.0 / (double)problemList.get(i).getProblem().numberOfVariables();
                double mutationDistributionIndex = 20.0;
                SMPSO algorithm = new SMPSOBuilder((DoubleProblem)problemList.get(i).getProblem(), (BoundedArchive)new CrowdingDistanceArchive(100)).setMutation((MutationOperator)new PolynomialMutation(mutationProbability, mutationDistributionIndex)).setMaxIterations(250).setSwarmSize(100).setSolutionListEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                NSGAII algorithm = new NSGAIIBuilder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 20.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().numberOfVariables(), 20.0), 100).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, problemList.get(i), run));
            }
            for (i = 0; i < problemList.size(); ++i) {
                SPEA2 algorithm = new SPEA2Builder(problemList.get(i).getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 10.0), (MutationOperator)new PolynomialMutation(1.0 / (double)problemList.get(i).getProblem().numberOfVariables(), 20.0)).build();
                algorithms.add(new ExperimentAlgorithm(algorithm, problemList.get(i), run));
            }
        }
        return algorithms;
    }
}

