/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.studies;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.uma.jmetal.algorithm.multiobjective.moead.AbstractMOEAD;
import org.uma.jmetal.algorithm.multiobjective.moead.MOEADBuilder;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAII;
import org.uma.jmetal.algorithm.multiobjective.nsgaii.NSGAIIBuilder;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSO;
import org.uma.jmetal.algorithm.multiobjective.smpso.SMPSOBuilder;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.ExperimentBuilder;
import org.uma.jmetal.lab.experiment.component.impl.ComputeQualityIndicators;
import org.uma.jmetal.lab.experiment.component.impl.ExecuteAlgorithms;
import org.uma.jmetal.lab.experiment.component.impl.GenerateBoxplotsWithR;
import org.uma.jmetal.lab.experiment.component.impl.GenerateFriedmanTestTables;
import org.uma.jmetal.lab.experiment.component.impl.GenerateLatexTablesWithStatistics;
import org.uma.jmetal.lab.experiment.component.impl.GenerateReferenceParetoSetAndFrontFromDoubleSolutions;
import org.uma.jmetal.lab.experiment.component.impl.GenerateWilcoxonTestTablesWithR;
import org.uma.jmetal.lab.experiment.util.ExperimentAlgorithm;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.crossover.impl.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT2;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT3;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT4;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT6;
import org.uma.jmetal.qualityindicator.impl.Epsilon;
import org.uma.jmetal.qualityindicator.impl.GenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistance;
import org.uma.jmetal.qualityindicator.impl.InvertedGenerationalDistancePlus;
import org.uma.jmetal.qualityindicator.impl.NormalizedHypervolume;
import org.uma.jmetal.qualityindicator.impl.Spread;
import org.uma.jmetal.qualityindicator.impl.hypervolume.impl.PISAHypervolume;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.archive.impl.CrowdingDistanceArchive;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.evaluator.impl.SequentialSolutionListEvaluator;

public class ZDTComputingReferenceParetoFrontsStudy {
    private static final int INDEPENDENT_RUNS = 25;

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Needed arguments: experimentBaseDirectory");
        }
        String experimentBaseDirectory = args[0];
        List problemList = List.of(new ExperimentProblem(new ZDT1()), new ExperimentProblem(new ZDT2()), new ExperimentProblem(new ZDT3()), new ExperimentProblem(new ZDT4()), new ExperimentProblem(new ZDT6()));
        List algorithmList = ZDTComputingReferenceParetoFrontsStudy.configureAlgorithmList(problemList);
        ExperimentBuilder zdt2Study = new ExperimentBuilder("ZDTStudy2");
        zdt2Study.setAlgorithmList(algorithmList);
        zdt2Study.setProblemList(problemList);
        zdt2Study.setExperimentBaseDirectory(experimentBaseDirectory);
        zdt2Study.setOutputParetoFrontFileName("FUN");
        zdt2Study.setOutputParetoSetFileName("VAR");
        zdt2Study.setReferenceFrontDirectory(experimentBaseDirectory + "/ZDTStudy2/referenceFronts");
        zdt2Study.setIndicatorList(Arrays.asList(new Epsilon(), new Spread(), new GenerationalDistance(), new PISAHypervolume(), new NormalizedHypervolume(), new InvertedGenerationalDistance(), new InvertedGenerationalDistancePlus()));
        zdt2Study.setIndependentRuns(25);
        zdt2Study.setNumberOfCores(8);
        Experiment experiment = zdt2Study.build();
        new ExecuteAlgorithms(experiment).run();
        new GenerateReferenceParetoSetAndFrontFromDoubleSolutions(experiment).run();
        new ComputeQualityIndicators(experiment).run();
        new GenerateLatexTablesWithStatistics(experiment).run();
        new GenerateWilcoxonTestTablesWithR(experiment).run();
        new GenerateFriedmanTestTables(experiment).run();
        new GenerateBoxplotsWithR(experiment).setRows(3).setColumns(3).setDisplayNotch().run();
    }

    static List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> configureAlgorithmList(List<ExperimentProblem<DoubleSolution>> problemList) {
        ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms = new ArrayList<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>>();
        for (int run = 0; run < 25; ++run) {
            ZDTComputingReferenceParetoFrontsStudy.smpso(problemList, algorithms, run);
            ZDTComputingReferenceParetoFrontsStudy.nsgaii(problemList, algorithms, run);
            ZDTComputingReferenceParetoFrontsStudy.moead(problemList, algorithms, run);
        }
        return algorithms;
    }

    private static void moead(List<ExperimentProblem<DoubleSolution>> problemList, List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms, int run) {
        for (ExperimentProblem<DoubleSolution> experimentProblem : problemList) {
            AbstractMOEAD algorithm = new MOEADBuilder(experimentProblem.getProblem(), MOEADBuilder.Variant.MOEAD).setCrossover((CrossoverOperator)new DifferentialEvolutionCrossover(1.0, 0.5, DifferentialEvolutionCrossover.DE_VARIANT.RAND_1_BIN)).setMutation((MutationOperator)new PolynomialMutation(1.0 / (double)experimentProblem.getProblem().numberOfVariables(), 20.0)).setMaxEvaluations(25000).setPopulationSize(100).setResultPopulationSize(100).setNeighborhoodSelectionProbability(0.9).setMaximumNumberOfReplacedSolutions(2).setNeighborSize(20).setFunctionType(AbstractMOEAD.FunctionType.TCHE).build();
            algorithms.add(new ExperimentAlgorithm(algorithm, experimentProblem, run));
        }
    }

    private static void nsgaii(List<ExperimentProblem<DoubleSolution>> problemList, List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms, int run) {
        for (ExperimentProblem<DoubleSolution> experimentProblem : problemList) {
            NSGAII algorithm = new NSGAIIBuilder(experimentProblem.getProblem(), (CrossoverOperator)new SBXCrossover(1.0, 20.0), (MutationOperator)new PolynomialMutation(1.0 / (double)experimentProblem.getProblem().numberOfVariables(), 20.0), 100).build();
            algorithms.add(new ExperimentAlgorithm(algorithm, experimentProblem, run));
        }
    }

    private static void smpso(List<ExperimentProblem<DoubleSolution>> problemList, List<ExperimentAlgorithm<DoubleSolution, List<DoubleSolution>>> algorithms, int run) {
        for (ExperimentProblem<DoubleSolution> experimentProblem : problemList) {
            double mutationProbability = 1.0 / (double)experimentProblem.getProblem().numberOfVariables();
            double mutationDistributionIndex = 20.0;
            SMPSO algorithm = new SMPSOBuilder((DoubleProblem)experimentProblem.getProblem(), (BoundedArchive)new CrowdingDistanceArchive(100)).setMutation((MutationOperator)new PolynomialMutation(mutationProbability, mutationDistributionIndex)).setMaxIterations(250).setSwarmSize(100).setSolutionListEvaluator((SolutionListEvaluator)new SequentialSolutionListEvaluator()).build();
            algorithms.add(new ExperimentAlgorithm(algorithm, experimentProblem, run));
        }
    }
}

