/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.util;

import java.io.File;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.lab.experiment.Experiment;
import org.uma.jmetal.lab.experiment.util.ExperimentProblem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class ExperimentAlgorithm<S extends Solution<?>, Result extends List<S>> {
    private Algorithm<Result> algorithm;
    private String algorithmTag;
    private String problemTag;
    private int runId;

    public ExperimentAlgorithm(Algorithm<Result> algorithm, String algorithmTag, ExperimentProblem<S> problem, int runId) {
        this.algorithm = algorithm;
        this.algorithmTag = algorithmTag;
        this.problemTag = problem.getTag();
        this.runId = runId;
    }

    public ExperimentAlgorithm(Algorithm<Result> algorithm, ExperimentProblem<S> problem, int runId) {
        this(algorithm, algorithm.getName(), problem, runId);
    }

    public void runAlgorithm(Experiment<?, ?> experimentData) {
        String outputDirectoryName = experimentData.getExperimentBaseDirectory() + "/data/" + this.algorithmTag + "/" + this.problemTag;
        File outputDirectory = new File(outputDirectoryName);
        if (!outputDirectory.exists()) {
            boolean result = new File(outputDirectoryName).mkdirs();
            if (result) {
                JMetalLogger.logger.info("Creating " + outputDirectoryName);
            } else {
                JMetalLogger.logger.severe("Creating " + outputDirectoryName + " failed");
            }
        }
        String funFile = outputDirectoryName + "/" + experimentData.getOutputParetoFrontFileName() + this.runId + ".csv";
        String varFile = outputDirectoryName + "/" + experimentData.getOutputParetoSetFileName() + this.runId + ".csv";
        String message = " Running algorithm: " + this.algorithmTag + ", problem: " + this.problemTag + ", run: " + this.runId + ", funFile: " + funFile;
        JMetalLogger.logger.info(message);
        try {
            this.algorithm.run();
            List population = (List)this.algorithm.getResult();
            new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext(varFile, ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext(funFile, ",")).print();
        }
        catch (Exception exception) {
            JMetalLogger.logger.warning("Execution failed: " + funFile + " has not been created.");
        }
    }

    public Algorithm<Result> getAlgorithm() {
        return this.algorithm;
    }

    public String getAlgorithmTag() {
        return this.algorithmTag;
    }

    public String getProblemTag() {
        return this.problemTag;
    }

    public int getRunId() {
        return this.runId;
    }
}

