/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.experiment.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.uma.jmetal.lab.experiment.util.CDFNormal;
import org.uma.jmetal.lab.experiment.util.Pareja;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class FriedmanTest {
    public static final boolean MINIMIZAR = true;
    public static final boolean MAXIMIZAR = false;
    private Table results;
    private boolean minimizar;
    private int numberOfAlgorithms;
    private int datasetCount;

    public FriedmanTest(boolean minimizar, Table table, StringColumn algorithms, StringColumn problems, String indicatorValueColumnName) {
        this.minimizar = minimizar;
        this.numberOfAlgorithms = algorithms.size();
        this.datasetCount = table.rowCount();
        double[][] mean = this.computeAveragePerformancePerAlgorithm(table, algorithms, problems, indicatorValueColumnName);
        Pareja[][] order = this.computeAndOrderRanking(mean, algorithms, problems);
        double[] rank = this.buildRanking(order, algorithms, problems);
        this.results = Table.create();
        this.results.addColumns(new Column[]{algorithms, DoubleColumn.create((String)"Ranking", (double[])rank)});
        this.results = this.results.sortAscendingOn(new String[]{"Ranking"});
    }

    private double[][] computeAveragePerformancePerAlgorithm(Table table, StringColumn algorithms, StringColumn problems, String indicatorValueColumnName) {
        double[][] mean = new double[problems.size()][algorithms.size()];
        for (int i = 0; i < problems.size(); ++i) {
            Table tableFilteredByProblem = this.filterTableBy(table, problems.name(), problems.get(i));
            for (int j = 0; j < algorithms.size(); ++j) {
                Table tableFilteredByProblemAndAlgorithm = this.filterTableBy(tableFilteredByProblem, algorithms.name(), algorithms.get(j));
                DoubleColumn results = tableFilteredByProblemAndAlgorithm.doubleColumn(indicatorValueColumnName);
                mean[i][j] = results.mean();
            }
        }
        return mean;
    }

    private Pareja[][] computeAndOrderRanking(double[][] mean, StringColumn algorithms, StringColumn problems) {
        Pareja[][] orden = new Pareja[problems.size()][algorithms.size()];
        for (int i = 0; i < problems.size(); ++i) {
            for (int j = 0; j < algorithms.size(); ++j) {
                orden[i][j] = new Pareja(j, mean[i][j], this.minimizar);
            }
            Arrays.sort(orden[i]);
        }
        return orden;
    }

    private double[] buildRanking(Pareja[][] orden, StringColumn algorithms, StringColumn problems) {
        int i;
        Pareja[][] rank = new Pareja[problems.size()][algorithms.size()];
        int position = 0;
        for (i = 0; i < problems.size(); ++i) {
            for (int j = 0; j < algorithms.size(); ++j) {
                boolean found = false;
                for (int k = 0; k < algorithms.size() && !found; ++k) {
                    if (orden[i][k].getIndice() != (double)j) continue;
                    found = true;
                    position = k + 1;
                }
                rank[i][j] = new Pareja(position, orden[i][position - 1].getValor(), this.minimizar);
            }
        }
        for (i = 0; i < problems.size(); ++i) {
            boolean[] seen = new boolean[algorithms.size()];
            ArrayList<Integer> notVisited = new ArrayList<Integer>();
            Arrays.fill(seen, false);
            for (int j = 0; j < algorithms.size(); ++j) {
                int k;
                notVisited.clear();
                double sum = rank[i][j].getIndice();
                seen[j] = true;
                int ig = 1;
                for (k = j + 1; k < algorithms.size(); ++k) {
                    if (rank[i][j].getValor() != rank[i][k].getValor() || seen[k]) continue;
                    sum += rank[i][k].getIndice();
                    ++ig;
                    notVisited.add(k);
                    seen[k] = true;
                }
                rank[i][j].setIndice(sum /= (double)ig);
                for (k = 0; k < notVisited.size(); ++k) {
                    rank[i][(Integer)notVisited.get(k)].setIndice(sum);
                }
            }
        }
        double[] averageRanking = new double[algorithms.size()];
        for (int i2 = 0; i2 < algorithms.size(); ++i2) {
            averageRanking[i2] = 0.0;
            for (int j = 0; j < problems.size(); ++j) {
                int n = i2;
                averageRanking[n] = averageRanking[n] + rank[j][i2].getIndice() / (double)problems.size();
            }
        }
        return averageRanking;
    }

    public void computeHolmTest() {
        this.computePValues();
        this.computeHolmValues();
        this.studyHypothesis();
    }

    private void computePValues() {
        double SE = Math.sqrt((double)this.numberOfAlgorithms * ((double)this.numberOfAlgorithms + 1.0) / (6.0 * (double)this.datasetCount));
        DoubleColumn rankingValues = this.results.doubleColumn("Ranking");
        double[] pValues = new double[this.numberOfAlgorithms];
        pValues[0] = 0.0;
        for (int i = 1; i < this.numberOfAlgorithms; ++i) {
            double z = (rankingValues.get(0) - rankingValues.get(i)) / SE;
            pValues[i] = 2.0 * CDFNormal.normp(-1.0 * Math.abs(z));
        }
        DoubleColumn holm = DoubleColumn.create((String)"p-value", (double[])pValues);
        this.results.addColumns(new Column[]{holm});
    }

    private void computeHolmValues() {
        double[] holmValues = new double[this.numberOfAlgorithms];
        holmValues[0] = 0.0;
        for (int i = 1; i < this.numberOfAlgorithms; ++i) {
            holmValues[i] = 0.05 / (double)i;
        }
        DoubleColumn holm = DoubleColumn.create((String)"Holm", (double[])holmValues);
        this.results.addColumns(new Column[]{holm});
    }

    private void studyHypothesis() {
        DoubleColumn pValues = this.results.doubleColumn("p-value");
        DoubleColumn holmValues = this.results.doubleColumn("Holm");
        String[] hypothesis = new String[this.numberOfAlgorithms];
        hypothesis[0] = "-";
        for (int i = this.numberOfAlgorithms - 1; i > 0; --i) {
            hypothesis[i] = i < this.numberOfAlgorithms - 1 && hypothesis[i + 1].equals("Accepted") ? "Accepted" : (pValues.get(i) < holmValues.get(i) ? "Rejected" : "Accepted");
        }
        StringColumn hypothesisColumn = StringColumn.create((String)"Hypothesis", (String[])hypothesis);
        this.results.addColumns(new Column[]{hypothesisColumn});
    }

    public Table getResults() {
        return this.results;
    }

    private Table filterTableBy(Table table, String columnName, String value) {
        return table.where(table.stringColumn(columnName).isEqualTo(value));
    }
}

