/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.operator;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.lab.visualization.plot.impl.PlotSmile;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.problem.singleobjective.Sphere;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.bounds.Bounds;

public class PolynomialMutationExample {
    public static void main(String[] args) throws FileNotFoundException {
        double distributionIndex;
        int granularity;
        int numberOfPoints;
        if (args.length != 3) {
            JMetalLogger.logger.info("Usage: numberOfSolutions granularity distributionIndex");
            JMetalLogger.logger.info("Using default parameters");
            numberOfPoints = 10000;
            granularity = 100;
            distributionIndex = 20.0;
        } else {
            numberOfPoints = Integer.parseInt(args[0]);
            granularity = Integer.parseInt(args[1]);
            distributionIndex = Double.parseDouble(args[2]);
        }
        Sphere problem = new Sphere(Integer.valueOf(1));
        PolynomialMutation mutation = new PolynomialMutation(1.0, distributionIndex);
        DoubleSolution solution = (DoubleSolution)problem.createSolution();
        solution.variables().set(0, 0.0);
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(numberOfPoints);
        for (int i = 0; i < numberOfPoints; ++i) {
            DoubleSolution newSolution = (DoubleSolution)solution.copy();
            mutation.execute((Object)newSolution);
            population.add(newSolution);
        }
        population.sort(Comparator.comparingDouble(sol -> sol.objectives()[0]));
        double[][] classifier = PolynomialMutationExample.classify(population, (DoubleProblem)problem, granularity);
        PlotSmile plot = new PlotSmile(classifier, "");
        plot.plot();
    }

    private static double[][] classify(List<DoubleSolution> solutions, DoubleProblem problem, int granularity) {
        Bounds bounds = (Bounds)problem.variableBounds().get(0);
        double grain = ((Double)bounds.getUpperBound() - (Double)bounds.getLowerBound()) / (double)granularity;
        double[][] classifier = new double[granularity][];
        for (int i = 0; i < granularity; ++i) {
            classifier[i] = new double[2];
            classifier[i][0] = (Double)bounds.getLowerBound() + (double)i * grain;
            classifier[i][1] = 0.0;
        }
        for (DoubleSolution solution : solutions) {
            boolean found = false;
            int index = 0;
            while (!found) {
                if ((Double)solution.variables().get(0) <= classifier[index][0]) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                if (index == granularity - 1) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                ++index;
            }
        }
        return classifier;
    }
}

