/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.operator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.lab.visualization.plot.impl.PlotSmile;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.problem.multiobjective.Kursawe;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class SBXCrossoverExample {
    public static void main(String[] args) {
        double distributionIndex;
        int granularity;
        int numberOfPoints;
        if (args.length != 3) {
            JMetalLogger.logger.info("Usage: numberOfSolutions granularity distributionIndex");
            JMetalLogger.logger.info("Using default parameters");
            numberOfPoints = 10000;
            granularity = 100;
            distributionIndex = 10.0;
        } else {
            numberOfPoints = Integer.parseInt(args[0]);
            granularity = Integer.parseInt(args[1]);
            distributionIndex = Double.parseDouble(args[2]);
        }
        Kursawe problem = new Kursawe(Integer.valueOf(1));
        SBXCrossover crossover = new SBXCrossover(1.0, distributionIndex);
        DoubleSolution solution1 = (DoubleSolution)problem.createSolution();
        DoubleSolution solution2 = (DoubleSolution)problem.createSolution();
        solution1.variables().set(0, -3.0);
        solution2.variables().set(0, 3.0);
        List<DoubleSolution> parents = Arrays.asList(solution1, solution2);
        ArrayList<DoubleSolution> population = new ArrayList<DoubleSolution>(numberOfPoints);
        for (int i = 0; i < numberOfPoints; ++i) {
            List solutions = (List)crossover.execute(parents);
            population.add((DoubleSolution)solutions.get(0));
            population.add((DoubleSolution)solutions.get(1));
        }
        population.sort(Comparator.comparingDouble(solution -> solution.objectives()[0]));
        new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("solutionsSBX")).print();
        double[][] classifier = SBXCrossoverExample.classify(population, (DoubleProblem)problem, granularity);
        PlotSmile plot = new PlotSmile(classifier, "");
        plot.plot();
    }

    private static double[][] classify(List<DoubleSolution> solutions, DoubleProblem problem, int granularity) {
        Bounds bounds = (Bounds)problem.variableBounds().get(0);
        double grain = ((Double)bounds.getUpperBound() - (Double)bounds.getLowerBound()) / (double)granularity;
        double[][] classifier = new double[granularity][];
        for (int i = 0; i < granularity; ++i) {
            classifier[i] = new double[2];
            classifier[i][0] = (Double)bounds.getLowerBound() + (double)i * grain;
            classifier[i][1] = 0.0;
        }
        for (DoubleSolution solution : solutions) {
            boolean found = false;
            int index = 0;
            while (!found) {
                if ((Double)solution.variables().get(0) <= classifier[index][0]) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                if (index == granularity - 1) {
                    double[] dArray = classifier[index];
                    dArray[1] = dArray[1] + 1.0;
                    found = true;
                    continue;
                }
                ++index;
            }
        }
        return classifier;
    }
}

