/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.visualization;

import java.io.IOException;
import java.util.LinkedList;
import org.uma.jmetal.lab.visualization.html.Html;
import org.uma.jmetal.lab.visualization.html.impl.HtmlFigure;
import org.uma.jmetal.lab.visualization.html.impl.HtmlGridView;
import org.uma.jmetal.lab.visualization.html.impl.htmlTable.impl.FriedmanTestTable;
import org.uma.jmetal.lab.visualization.html.impl.htmlTable.impl.MedianValuesTable;
import org.uma.jmetal.lab.visualization.html.impl.htmlTable.impl.WilcoxonTestTable;
import org.uma.jmetal.util.errorchecking.JMetalException;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.plotly.components.Figure;
import tech.tablesaw.plotly.components.Layout;
import tech.tablesaw.plotly.traces.BoxTrace;
import tech.tablesaw.plotly.traces.Scatter3DTrace;
import tech.tablesaw.plotly.traces.ScatterTrace;
import tech.tablesaw.plotly.traces.Trace;

public class StudyVisualizer {
    private static final String INDICATOR_SUMMARY_CSV = "QualityIndicatorSummary.csv";
    private static final String ALGORITHM = "Algorithm";
    private static final String PROBLEM = "Problem";
    private static final String INDICATOR_NAME = "IndicatorName";
    private static final String INDICATOR_VALUE = "IndicatorValue";
    private String folderPath;
    private Table table;
    private TYPE_OF_FRONT_TO_SHOW typeOfFrontToShow;

    public StudyVisualizer(String path, TYPE_OF_FRONT_TO_SHOW typeOfFrontToShow) throws IOException {
        this.folderPath = path;
        this.table = Table.read().csv(path + "/QualityIndicatorSummary.csv");
        this.typeOfFrontToShow = typeOfFrontToShow;
    }

    public StudyVisualizer(String path) throws IOException {
        this(path, null);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            throw new JMetalException("Argument required: name of the experiment base directory");
        }
        String directory = args[0];
        StudyVisualizer visualizer = new StudyVisualizer(directory, TYPE_OF_FRONT_TO_SHOW.NONE);
        visualizer.createHTMLPageForEachIndicator();
    }

    public void createHTMLPageForEachIndicator() throws IOException {
        StringColumn indicators = this.getUniquesValuesOfStringColumn(INDICATOR_NAME);
        for (String indicator : indicators) {
            Html htmlPage = this.createHtmlPage(indicator);
            htmlPage.setPathFolder(this.folderPath + "/html");
            htmlPage.save();
        }
    }

    Html createHtmlPage(String indicator) throws IOException {
        Html htmlPage = new Html(indicator);
        HtmlGridView tablesGridView = this.createTestTables(indicator);
        htmlPage.addComponent(tablesGridView);
        StringColumn problems = this.getUniquesValuesOfStringColumn(PROBLEM);
        if (this.typeOfFrontToShow == TYPE_OF_FRONT_TO_SHOW.NONE) {
            HtmlGridView boxPlotsGrid = new HtmlGridView();
            for (String problem : problems) {
                HtmlFigure figure = this.createBoxPlot(indicator, problem);
                boxPlotsGrid.addComponent(figure);
            }
            htmlPage.addComponent(boxPlotsGrid);
        } else {
            for (String problem : problems) {
                HtmlGridView gridView = this.createInformationForEachProblem(indicator, problem);
                htmlPage.addComponent(gridView);
            }
        }
        return htmlPage;
    }

    private HtmlGridView createTestTables(String indicator) {
        StringColumn algorithms = this.getUniquesValuesOfStringColumn(ALGORITHM);
        StringColumn problems = this.getUniquesValuesOfStringColumn(PROBLEM);
        Table tableFilteredByIndicator = this.filterTableByIndicator(this.table, indicator);
        boolean minimize = true;
        MedianValuesTable medianValuesTable = new MedianValuesTable(tableFilteredByIndicator, indicator, algorithms, problems, INDICATOR_VALUE);
        WilcoxonTestTable wilcoxonTable = new WilcoxonTestTable(tableFilteredByIndicator, indicator, algorithms, problems, INDICATOR_VALUE);
        if (indicator.equals("HV")) {
            minimize = false;
        }
        FriedmanTestTable friedmanTable = new FriedmanTestTable(tableFilteredByIndicator, algorithms, problems, minimize);
        HtmlGridView htmlGridView = new HtmlGridView();
        htmlGridView.addComponent(medianValuesTable);
        htmlGridView.addComponent(wilcoxonTable);
        htmlGridView.addComponent(friedmanTable);
        return htmlGridView;
    }

    private HtmlGridView createInformationForEachProblem(String indicator, String problem) throws IOException {
        HtmlGridView gridView = new HtmlGridView(problem);
        HtmlFigure boxPlot = this.createBoxPlot(indicator, problem);
        gridView.addComponent(boxPlot);
        StringColumn algorithms = this.getUniquesValuesOfStringColumn(ALGORITHM);
        for (String algorithm : algorithms) {
            HtmlFigure frontPlot = this.createFrontPlot(indicator, problem, algorithm);
            gridView.addComponent(frontPlot);
        }
        return gridView;
    }

    private HtmlFigure createBoxPlot(String indicator, String problem) {
        Table tableFilteredByIndicator = this.filterTableByIndicator(this.table, indicator);
        Table tableFilteredByIndicatorAndProblem = this.filterTableByProblem(tableFilteredByIndicator, problem);
        BoxTrace trace = BoxTrace.builder((CategoricalColumn)tableFilteredByIndicatorAndProblem.categoricalColumn(ALGORITHM), (NumericColumn)tableFilteredByIndicatorAndProblem.doubleColumn(INDICATOR_VALUE)).build();
        Layout layout = Layout.builder().title(problem).build();
        Figure figure = new Figure(layout, new Trace[]{trace});
        return new HtmlFigure(figure);
    }

    private HtmlFigure createFrontPlot(String indicator, String problem, String algorithm) throws IOException {
        String frontFileName = "";
        if (this.typeOfFrontToShow == TYPE_OF_FRONT_TO_SHOW.BEST) {
            frontFileName = "BEST";
        } else if (this.typeOfFrontToShow == TYPE_OF_FRONT_TO_SHOW.MEDIAN) {
            frontFileName = "MEDIAN";
        }
        String csv = algorithm + "/" + problem + "/" + frontFileName + "_" + indicator + "_FUN.csv";
        String path = this.folderPath + "/data/" + csv;
        CsvReadOptions csvReader = CsvReadOptions.builder((String)path).header(false).build();
        Table funTable = Table.read().usingOptions((ReadOptions)csvReader);
        int numberOfObjectives = funTable.columnCount();
        ScatterTrace scatterTrace = null;
        if (numberOfObjectives == 2) {
            scatterTrace = ScatterTrace.builder((Column)funTable.column(0), (Column)funTable.column(1)).build();
        } else if (numberOfObjectives == 3) {
            scatterTrace = Scatter3DTrace.builder((NumericColumn)funTable.numberColumn(0), (NumericColumn)funTable.numberColumn(1), (NumericColumn)funTable.numberColumn(2)).build();
        }
        Layout layout = Layout.builder().title(algorithm).build();
        Figure figure = new Figure(layout, new Trace[]{scatterTrace});
        return new HtmlFigure(figure);
    }

    private StringColumn getUniquesValuesOfStringColumn(String columnName) {
        return this.dropDuplicateRowsInColumn(this.table.stringColumn(columnName));
    }

    public StringColumn dropDuplicateRowsInColumn(StringColumn column) {
        LinkedList<String> result = new LinkedList<String>();
        for (int row = 0; row < column.size(); ++row) {
            if (result.contains(column.get(row))) continue;
            result.add(column.get(row));
        }
        return StringColumn.create((String)column.name(), result);
    }

    private Table filterTableByIndicator(Table table, String indicator) {
        return table.where(table.stringColumn(INDICATOR_NAME).isEqualTo(indicator));
    }

    private Table filterTableByProblem(Table table, String problem) {
        return table.where(table.stringColumn(PROBLEM).isEqualTo(problem));
    }

    public static enum TYPE_OF_FRONT_TO_SHOW {
        NONE,
        BEST,
        MEDIAN;

    }
}

