/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.visualization.html.impl.htmlTable.impl;

import java.text.DecimalFormat;
import org.uma.jmetal.lab.experiment.util.FriedmanTest;
import org.uma.jmetal.lab.visualization.html.impl.htmlTable.HtmlTable;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;

public class FriedmanTestTable
extends HtmlTable<String> {
    public FriedmanTestTable(Table table, StringColumn algorithms, StringColumn problems, boolean minimizar) {
        this.title = "Friedman ranking and Holm test";
        FriedmanTest test = new FriedmanTest(minimizar, table, algorithms, problems, "IndicatorValue");
        test.computeHolmTest();
        Table ranking = test.getResults();
        this.headersColumn = ranking.columnNames().toArray(new String[0]);
        this.data = new String[algorithms.size()][ranking.columnCount()];
        for (int i = 0; i < algorithms.size(); ++i) {
            for (int j = 0; j < ranking.columnCount(); ++j) {
                DecimalFormat format;
                if (j == ranking.columnIndex("Algorithm")) {
                    ((String[][])this.data)[i][j] = ranking.stringColumn(0).get(i);
                    continue;
                }
                if (j == ranking.columnIndex("Hypothesis")) {
                    ((String[][])this.data)[i][j] = ranking.stringColumn(j).get(i);
                    continue;
                }
                if (j == ranking.columnIndex("p-value")) {
                    format = new DecimalFormat("0.###E0");
                    ((String[][])this.data)[i][j] = format.format(ranking.doubleColumn(j).get(i));
                    continue;
                }
                format = new DecimalFormat("##.###");
                ((String[][])this.data)[i][j] = format.format(ranking.doubleColumn(j).get(i));
            }
        }
    }
}

