/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.visualization.html.impl.htmlTable.impl;

import java.util.Arrays;
import org.apache.commons.math3.stat.inference.WilcoxonSignedRankTest;
import org.uma.jmetal.lab.visualization.html.impl.htmlTable.HtmlTable;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;

public class WilcoxonTestTable
extends HtmlTable<Difference[]> {
    private static final String[] INDICATORS_TO_MAXIMIZE = new String[]{"HV"};

    public WilcoxonTestTable(Table table, String indicator, StringColumn algorithms, StringColumn problems, String indicatorValueColumnName) {
        this.title = "Wilcoxon Test";
        this.headersColumn = ((StringColumn)algorithms.last(algorithms.size() - 1)).asObjectArray();
        this.headersRow = algorithms.asObjectArray();
        this.data = new Difference[algorithms.size() - 1][algorithms.size() - 1][problems.size()];
        for (int row = 0; row < algorithms.size() - 1; ++row) {
            Table tableAlgorithmA = this.filterTableBy(table, algorithms.name(), algorithms.get(row));
            for (int column = 1; column < algorithms.size(); ++column) {
                Table tableAlgorithmB = this.filterTableBy(table, algorithms.name(), algorithms.get(column));
                for (int index = 0; index < problems.size(); ++index) {
                    if (row == column) {
                        ((Difference[][][])this.data)[row][column][index] = null;
                        continue;
                    }
                    Table tableAlgorithmAByProblem = this.filterTableBy(tableAlgorithmA, problems.name(), problems.get(index));
                    Table tableAlgorithmBByProblem = this.filterTableBy(tableAlgorithmB, problems.name(), problems.get(index));
                    DoubleColumn resultsAlgorithmA = tableAlgorithmAByProblem.doubleColumn(indicatorValueColumnName);
                    DoubleColumn resultsAlgorithmB = tableAlgorithmBByProblem.doubleColumn(indicatorValueColumnName);
                    ((Difference[][][])this.data)[row][column - 1][index] = Arrays.asList(INDICATORS_TO_MAXIMIZE).contains(indicator) ? this.compare(resultsAlgorithmA, resultsAlgorithmB) : this.compare(resultsAlgorithmB, resultsAlgorithmA);
                }
            }
        }
    }

    public static double[] convertDoubleArray(Double[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    private Table filterTableBy(Table table, String columnName, String value) {
        return table.where(table.stringColumn(columnName).isEqualTo(value));
    }

    public Difference compare(DoubleColumn columnA, DoubleColumn columnB) {
        double[] b;
        WilcoxonSignedRankTest wilcoxon = new WilcoxonSignedRankTest();
        double[] a = WilcoxonTestTable.convertDoubleArray(columnA.asObjectArray());
        if (wilcoxon.wilcoxonSignedRankTest(a, b = WilcoxonTestTable.convertDoubleArray(columnB.asObjectArray()), false) < 0.05) {
            if (columnA.median() >= columnB.median()) {
                return Difference.BETTER;
            }
            return Difference.WORSE;
        }
        return Difference.NO_DIFFERENCE;
    }

    @Override
    protected StringBuilder createRowOfData(int index) {
        StringBuilder html = new StringBuilder();
        for (Difference[] differences : ((Difference[][][])this.data)[index]) {
            html.append("<td>");
            html.append("<div class='horizontal'>");
            for (Difference difference : differences) {
                if (difference == Difference.BETTER) {
                    html.append("<a> + </a>");
                }
                if (difference == Difference.WORSE) {
                    html.append("<a> - </a>");
                }
                if (difference != Difference.NO_DIFFERENCE) continue;
                html.append("<a> = </a>");
            }
            html.append("</div></td>");
        }
        return html;
    }

    @Override
    public String getCSS() {
        StringBuilder css = new StringBuilder(super.getCSS());
        css.append(".horizontal { display: flex; justify-content: space-evenly; align-items: center;}");
        css.append(".fas { flex-shrink: 0; margin: 1px; color: #6b6b6b} ");
        return css.toString();
    }

    public static enum Difference {
        BETTER,
        WORSE,
        NO_DIFFERENCE;

    }
}

