/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.visualization.plot.impl;

import org.uma.jmetal.lab.visualization.plot.PlotFront;
import org.uma.jmetal.util.errorchecking.Check;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotly.Plot;
import tech.tablesaw.plotly.api.ScatterPlot;
import tech.tablesaw.plotly.components.Figure;

public class Plot2D
implements PlotFront {
    private double[][] matrix;
    private String plotTitle;

    public Plot2D(double[][] matrix, String title) {
        Check.notNull((Object)matrix);
        Check.that((matrix.length >= 1 ? 1 : 0) != 0, (String)"The data matrix is empty");
        Check.that((matrix[0].length == 2 ? 1 : 0) != 0, (String)"The data matrix does not have two columns");
        this.matrix = matrix;
        this.plotTitle = title;
    }

    public Plot2D(double[][] matrix) {
        this(matrix, "Front");
    }

    @Override
    public void plot() {
        int numberOfRows = this.matrix.length;
        double[] f1 = new double[numberOfRows];
        double[] f2 = new double[numberOfRows];
        for (int i = 0; i < numberOfRows; ++i) {
            f1[i] = this.matrix[i][0];
            f2[i] = this.matrix[i][1];
        }
        Table table = Table.create((String)"table").addColumns(new Column[]{DoubleColumn.create((String)"f1", (double[])f1), DoubleColumn.create((String)"f2", (double[])f2)});
        Plot.show((Figure)ScatterPlot.create((String)this.plotTitle, (Table)table, (String)"f1", (String)"f2"));
    }
}

