/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.lab.visualization.plot.impl;

import org.uma.jmetal.lab.visualization.plot.PlotFront;
import org.uma.jmetal.util.errorchecking.Check;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotly.Plot;
import tech.tablesaw.plotly.api.Scatter3DPlot;
import tech.tablesaw.plotly.components.Figure;

public class Plot3D
implements PlotFront {
    private double[][] matrix;
    private String plotTitle;

    public Plot3D(double[][] matrix, String title) {
        Check.notNull((Object)matrix);
        Check.that((matrix.length >= 1 ? 1 : 0) != 0, (String)"The data matrix is empty");
        Check.that((matrix[0].length == 3 ? 1 : 0) != 0, (String)"The data matrix does not have three columns");
        this.plotTitle = title;
        this.matrix = matrix;
    }

    public Plot3D(double[][] matrix) {
        this(matrix, "Front");
    }

    @Override
    public void plot() {
        int numberOfRows = this.matrix.length;
        double[] f1 = new double[numberOfRows];
        double[] f2 = new double[numberOfRows];
        double[] f3 = new double[numberOfRows];
        for (int i = 0; i < numberOfRows; ++i) {
            f1[i] = this.matrix[i][0];
            f2[i] = this.matrix[i][1];
            f3[i] = this.matrix[i][2];
        }
        Table table = Table.create((String)"table").addColumns(new Column[]{DoubleColumn.create((String)"f1", (double[])f1), DoubleColumn.create((String)"f2", (double[])f2), DoubleColumn.create((String)"f3", (double[])f3)});
        table.summary();
        Plot.show((Figure)Scatter3DPlot.create((String)this.plotTitle, (Table)table, (String)"f1", (String)"f2", (String)"f3"));
    }
}

