/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.parallel.asynchronous.algorithm;

import java.util.List;
import org.uma.jmetal.parallel.asynchronous.task.ParallelTask;

public interface AsynchronousParallelAlgorithm<T extends ParallelTask<?>, R> {
    public void submitInitialTasks(List<T> var1);

    public List<T> createInitialTasks();

    public T waitForComputedTask();

    public void processComputedTask(T var1);

    public void submitTask(T var1);

    public T createNewTask();

    public boolean thereAreInitialTasksPending(List<T> var1);

    public T getInitialTask(List<T> var1);

    public boolean stoppingConditionIsNotMet();

    public void initProgress();

    public void updateProgress();

    public R getResult();

    default public void run() {
        List<T> initialTasks = this.createInitialTasks();
        this.submitInitialTasks(initialTasks);
        this.initProgress();
        while (this.stoppingConditionIsNotMet()) {
            T computedTask = this.waitForComputedTask();
            this.processComputedTask(computedTask);
            if (this.thereAreInitialTasksPending(initialTasks)) {
                this.submitTask(this.getInitialTask(initialTasks));
            } else {
                this.submitTask(this.createNewTask());
            }
            this.updateProgress();
        }
    }
}

