/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.parallel.asynchronous.algorithm.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.uma.jmetal.component.catalogue.common.termination.Termination;
import org.uma.jmetal.component.catalogue.ea.replacement.Replacement;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.parallel.asynchronous.multithreaded.Master;
import org.uma.jmetal.parallel.asynchronous.multithreaded.Worker;
import org.uma.jmetal.parallel.asynchronous.task.ParallelTask;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.observable.Observable;
import org.uma.jmetal.util.observable.impl.DefaultObservable;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class AsynchronousMultiThreadedGeneticAlgorithm<S extends Solution<?>>
extends Master<ParallelTask<S>, List<S>> {
    private Problem<S> problem;
    private CrossoverOperator<S> crossover;
    private MutationOperator<S> mutation;
    private SelectionOperator<List<S>, S> selection;
    private Replacement<S> replacement;
    private Termination termination;
    private List<S> population = new ArrayList<S>();
    private int populationSize;
    private int evaluations = 0;
    private long initTime;
    private Map<String, Object> attributes;
    private Observable<Map<String, Object>> observable;
    private int numberOfCores;

    public AsynchronousMultiThreadedGeneticAlgorithm(int numberOfCores, Problem<S> problem, int populationSize, CrossoverOperator<S> crossover, MutationOperator<S> mutation, SelectionOperator<List<S>, S> selection, Replacement<S> replacement, Termination termination) {
        super(numberOfCores);
        this.problem = problem;
        this.crossover = crossover;
        this.mutation = mutation;
        this.populationSize = populationSize;
        this.termination = termination;
        this.selection = selection;
        this.replacement = replacement;
        this.attributes = new HashMap<String, Object>();
        this.observable = new DefaultObservable("Observable");
        this.numberOfCores = numberOfCores;
        this.createWorkers(numberOfCores, problem);
    }

    private void createWorkers(int numberOfCores, Problem<S> problem) {
        IntStream.range(0, numberOfCores).forEach(i -> new Worker<ParallelTask>(task -> {
            problem.evaluate((Object)((Solution)task.getContents()));
            return ParallelTask.create(this.createTaskIdentifier(), (Solution)task.getContents());
        }, this.pendingTaskQueue, this.completedTaskQueue).start());
    }

    private int createTaskIdentifier() {
        return JMetalRandom.getInstance().nextInt(0, 1000000000);
    }

    @Override
    public void initProgress() {
        this.attributes.put("EVALUATIONS", this.evaluations);
        this.attributes.put("POPULATION", this.population);
        this.attributes.put("COMPUTING_TIME", System.currentTimeMillis() - this.initTime);
        this.observable.setChanged();
        this.observable.notifyObservers(this.attributes);
    }

    @Override
    public void updateProgress() {
        this.attributes.put("EVALUATIONS", this.evaluations);
        this.attributes.put("POPULATION", this.population);
        this.attributes.put("COMPUTING_TIME", System.currentTimeMillis() - this.initTime);
        this.attributes.put("BEST_SOLUTION", this.population.get(0));
        this.observable.setChanged();
        this.observable.notifyObservers(this.attributes);
    }

    @Override
    public List<ParallelTask<S>> createInitialTasks() {
        ArrayList initialPopulation = new ArrayList();
        ArrayList initialTaskList = new ArrayList();
        IntStream.range(0, this.populationSize).forEach(i -> initialPopulation.add((Solution)this.problem.createSolution()));
        initialPopulation.forEach(solution -> {
            int taskId = JMetalRandom.getInstance().nextInt(0, 1000);
            initialTaskList.add(ParallelTask.create(taskId, solution));
        });
        return initialTaskList;
    }

    @Override
    public void submitInitialTasks(List<ParallelTask<S>> initialTaskList) {
        if (initialTaskList.size() >= this.numberOfCores) {
            initialTaskList.forEach(this::submitTask);
        } else {
            initialTaskList.forEach(this::submitTask);
            for (int idleWorkers = this.numberOfCores - initialTaskList.size(); idleWorkers > 0; --idleWorkers) {
                this.submitTask(this.createNewTask());
            }
        }
    }

    @Override
    public void processComputedTask(ParallelTask<S> task) {
        ++this.evaluations;
        if (this.population.size() < this.populationSize) {
            this.population.add((Solution)task.getContents());
        } else {
            ArrayList<Solution> offspringPopulation = new ArrayList<Solution>(1);
            offspringPopulation.add((Solution)task.getContents());
            this.population = this.replacement.replace(this.population, offspringPopulation);
            Check.that((this.population.size() == this.populationSize ? 1 : 0) != 0, (String)"The population size is incorrect");
        }
    }

    @Override
    public void submitTask(ParallelTask<S> task) {
        this.pendingTaskQueue.add(task);
    }

    @Override
    public ParallelTask<S> createNewTask() {
        int numberOfParents = this.crossover.numberOfRequiredParents();
        if (this.population.size() > numberOfParents) {
            ArrayList<Solution> parents = new ArrayList<Solution>(numberOfParents);
            for (int i = 0; i < numberOfParents; ++i) {
                parents.add((Solution)this.selection.execute(this.population));
            }
            List offspring = (List)this.crossover.execute(parents);
            this.mutation.execute((Object)((Solution)offspring.get(0)));
            return ParallelTask.create(this.createTaskIdentifier(), (Solution)offspring.get(0));
        }
        return ParallelTask.create(this.createTaskIdentifier(), (Solution)this.problem.createSolution());
    }

    @Override
    public boolean stoppingConditionIsNotMet() {
        return !this.termination.isMet(this.attributes);
    }

    @Override
    public void run() {
        this.initTime = System.currentTimeMillis();
        super.run();
    }

    @Override
    public List<S> getResult() {
        return this.population;
    }

    public Observable<Map<String, Object>> getObservable() {
        return this.observable;
    }
}

