/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.parallel.asynchronous.multithreaded;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.uma.jmetal.parallel.asynchronous.algorithm.AsynchronousParallelAlgorithm;
import org.uma.jmetal.parallel.asynchronous.task.ParallelTask;

public abstract class Master<T extends ParallelTask<?>, R>
implements AsynchronousParallelAlgorithm<T, R> {
    protected int numberOfCores;
    protected BlockingQueue<T> completedTaskQueue;
    protected BlockingQueue<T> pendingTaskQueue;

    public Master(int numberOfCores) {
        this.numberOfCores = numberOfCores;
        this.completedTaskQueue = new LinkedBlockingQueue<T>();
        this.pendingTaskQueue = new LinkedBlockingQueue<T>();
    }

    @Override
    public void submitInitialTasks(List<T> initialTasks) {
        if (initialTasks.size() >= this.numberOfCores) {
            initialTasks.forEach(this::submitTask);
        } else {
            initialTasks.forEach(this::submitTask);
            for (int idleWorkers = this.numberOfCores - initialTasks.size(); idleWorkers > 0; --idleWorkers) {
                this.submitTask(this.createNewTask());
            }
        }
    }

    @Override
    public T waitForComputedTask() {
        ParallelTask evaluatedTask = null;
        try {
            evaluatedTask = (ParallelTask)this.completedTaskQueue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return (T)evaluatedTask;
    }

    @Override
    public abstract void processComputedTask(T var1);

    @Override
    public void submitTask(T task) {
        this.pendingTaskQueue.add(task);
    }

    @Override
    public abstract T createNewTask();

    @Override
    public boolean thereAreInitialTasksPending(List<T> initialTasks) {
        return initialTasks.size() > 0;
    }

    @Override
    public T getInitialTask(List<T> initialTasks) {
        ParallelTask initialTask = (ParallelTask)initialTasks.get(0);
        initialTasks.remove(0);
        return (T)initialTask;
    }

    @Override
    public abstract boolean stoppingConditionIsNotMet();

    public BlockingQueue<T> getCompletedTaskQueue() {
        return this.completedTaskQueue;
    }

    public BlockingQueue<T> getPendingTaskQueue() {
        return this.pendingTaskQueue;
    }
}

