/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.parallel.example;

import java.util.List;
import org.uma.jmetal.component.catalogue.common.termination.Termination;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.parallel.asynchronous.algorithm.impl.AsynchronousMultiThreadedNSGAII;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT1;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.observer.impl.RunTimeChartObserver;

public class AsynchronousMasterWorkerBasedNSGAIIExample {
    public static void main(String[] args) {
        int populationSize = 100;
        int maxEvaluations = 25000;
        int numberOfCores = 32;
        ZDT1 problem = new ZDT1(){

            public DoubleSolution evaluate(DoubleSolution solution) {
                super.evaluate(solution);
                this.computingDelay();
                return solution;
            }

            private void computingDelay() {
                for (long i = 0L; i < 1000L; ++i) {
                    for (long j = 0L; j < 10000L; ++j) {
                        double d = Math.sin(i) * Math.cos(j);
                    }
                }
            }
        };
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.numberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        long initTime = System.currentTimeMillis();
        AsynchronousMultiThreadedNSGAII nsgaii = new AsynchronousMultiThreadedNSGAII(numberOfCores, problem, populationSize, crossover, mutation, (Termination)new TerminationByEvaluations(maxEvaluations));
        RunTimeChartObserver runTimeChartObserver = new RunTimeChartObserver("NSGA-II", 80, 10, "resources/referenceFrontsCSV/ZDT1.csv");
        nsgaii.getObservable().register((Observer)runTimeChartObserver);
        nsgaii.run();
        long endTime = System.currentTimeMillis();
        Object resultList = nsgaii.getResult();
        JMetalLogger.logger.info("Computing time: " + (endTime - initTime));
        new SolutionListOutput((List)resultList).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        System.exit(0);
    }
}

